//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_SKEL_IMAGING_INBETWEEN_SHAPE_SCHEMA_H
#define PXR_USD_IMAGING_USD_SKEL_IMAGING_INBETWEEN_SHAPE_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdSkelImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_SKEL_IMAGING_INBETWEEN_SHAPE_SCHEMA_TOKENS \
    (weight) \
    (offsets) \
    (normalOffsets) \

TF_DECLARE_PUBLIC_TOKENS(UsdSkelImagingInbetweenShapeSchemaTokens, USDSKELIMAGING_API,
    USD_SKEL_IMAGING_INBETWEEN_SHAPE_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class UsdSkelImagingInbetweenShapeSchema
///
/// Corresponds to UsdSkelInbetweenShape. Each instance corresponds to a group
/// of attributes on a UsdSkelBlendShape that share a prefix inbetweens:NAME.
///
class UsdSkelImagingInbetweenShapeSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdSkelImagingInbetweenShapeSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Corresponds to Usd attribute metadata
    USDSKELIMAGING_API
    HdFloatDataSourceHandle GetWeight() const;

    USDSKELIMAGING_API
    HdVec3fArrayDataSourceHandle GetOffsets() const;

    USDSKELIMAGING_API
    HdVec3fArrayDataSourceHandle GetNormalOffsets() const; 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDSKELIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdFloatDataSourceHandle &weight,
        const HdVec3fArrayDataSourceHandle &offsets,
        const HdVec3fArrayDataSourceHandle &normalOffsets
    );

    /// \class UsdSkelImagingInbetweenShapeSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDSKELIMAGING_API
        Builder &SetWeight(
            const HdFloatDataSourceHandle &weight);
        USDSKELIMAGING_API
        Builder &SetOffsets(
            const HdVec3fArrayDataSourceHandle &offsets);
        USDSKELIMAGING_API
        Builder &SetNormalOffsets(
            const HdVec3fArrayDataSourceHandle &normalOffsets);

        /// Returns a container data source containing the members set thus far.
        USDSKELIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdFloatDataSourceHandle _weight;
        HdVec3fArrayDataSourceHandle _offsets;
        HdVec3fArrayDataSourceHandle _normalOffsets;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif
