/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.handler.extraction.ExtractionBackend;
import org.apache.solr.handler.extraction.ExtractionMetadata;
import org.apache.solr.handler.extraction.ExtractionRequest;
import org.apache.solr.handler.extraction.ExtractionResult;
import org.apache.solr.handler.extraction.RegexRulesPasswordProvider;
import org.apache.solr.handler.extraction.TikaServerParser;
import org.apache.solr.handler.extraction.fromtika.BodyContentHandler;
import org.apache.solr.util.RefCounted;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamRequestContent;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.xml.sax.helpers.DefaultHandler;

public class TikaServerExtractionBackend
implements ExtractionBackend {
    public static final long DEFAULT_MAXCHARS_LIMIT = 0x6400000L;
    private static final Object INIT_LOCK = new Object();
    private final String baseUrl;
    private static final int DEFAULT_TIMEOUT_SECONDS = 180;
    private final Duration defaultTimeout;
    private final TikaServerParser tikaServerResponseParser = new TikaServerParser();
    private boolean tikaMetadataCompatibility;
    private HashMap<String, Object> initArgsMap = new HashMap();
    private final long maxCharsLimit;
    private static volatile RefCounted<HttpClientResources> SHARED_RESOURCES;
    private RefCounted<HttpClientResources> acquiredResourcesRef;
    public static final String NAME = "tikaserver";
    private final Map<String, String> fieldMappings = new LinkedHashMap<String, String>();

    public TikaServerExtractionBackend(String baseUrl) {
        this(baseUrl, 180, null, 0x6400000L);
    }

    public TikaServerExtractionBackend(String baseUrl, int timeoutSeconds, NamedList<?> initArgs, long maxCharsLimit) {
        Object metaCompatObh;
        this.fieldMappings.put("dc:title", "title");
        this.fieldMappings.put("dc:creator", "author");
        this.fieldMappings.put("dc:description", "description");
        this.fieldMappings.put("dc:subject", "subject");
        this.fieldMappings.put("dc:language", "language");
        this.fieldMappings.put("dc:publisher", "publisher");
        this.fieldMappings.put("dcterms:created", "created");
        this.fieldMappings.put("dcterms:modified", "modified");
        this.fieldMappings.put("meta:author", "Author");
        this.fieldMappings.put("meta:creation-date", "Creation-Date");
        this.fieldMappings.put("meta:save-date", "Last-Save-Date");
        this.fieldMappings.put("meta:keyword", "Keywords");
        this.fieldMappings.put("pdf:docinfo:keywords", "Keywords");
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("baseUrl cannot be null or empty");
        }
        try {
            URI uri = new URI(baseUrl);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                throw new IllegalArgumentException("baseUrl must use http or https scheme, got: " + baseUrl);
            }
            uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid baseUrl: " + baseUrl, e);
        }
        this.maxCharsLimit = maxCharsLimit;
        if (initArgs != null) {
            initArgs.toMap(this.initArgsMap);
        }
        if ((metaCompatObh = this.initArgsMap.get("tikaserver.metadata.compatibility")) != null) {
            this.tikaMetadataCompatibility = Boolean.parseBoolean(metaCompatObh.toString());
        }
        if (timeoutSeconds <= 0) {
            timeoutSeconds = 180;
        }
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
        this.defaultTimeout = Duration.ofSeconds(timeoutSeconds > 0 ? (long)timeoutSeconds : 180L);
        this.acquiredResourcesRef = TikaServerExtractionBackend.initializeHttpClient().incref();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public ExtractionResult extract(InputStream inputStream, ExtractionRequest request) throws Exception {
        try (InputStream tikaResponse = this.callTikaServer(inputStream, request);){
            ExtractionMetadata md = this.buildMetadataFromRequest(request);
            BodyContentHandler bodyContentHandler = new BodyContentHandler(-1);
            if (request.tikaServerRecursive) {
                this.tikaServerResponseParser.parseRmetaJson(tikaResponse, bodyContentHandler, md);
            } else {
                this.tikaServerResponseParser.parseXml(tikaResponse, bodyContentHandler, md);
            }
            if (this.tikaMetadataCompatibility) {
                this.appendBackCompatTikaMetadata(md);
            }
            ExtractionResult extractionResult = new ExtractionResult(bodyContentHandler.toString(), md);
            return extractionResult;
        }
    }

    @Override
    public void extractWithSaxHandler(InputStream inputStream, ExtractionRequest request, ExtractionMetadata md, DefaultHandler saxContentHandler) throws Exception {
        try (InputStream tikaResponse = this.callTikaServer(inputStream, request);){
            if (request.tikaServerRecursive) {
                this.tikaServerResponseParser.parseRmetaJson(tikaResponse, saxContentHandler, md);
            } else {
                this.tikaServerResponseParser.parseXml(tikaResponse, saxContentHandler, md);
            }
            if (this.tikaMetadataCompatibility) {
                this.appendBackCompatTikaMetadata(md);
            }
        }
    }

    InputStream callTikaServer(InputStream inputStream, ExtractionRequest request) throws Exception {
        Response response;
        String contentType;
        String url = this.baseUrl + (request.tikaServerRecursive ? "/rmeta" : "/tika");
        HttpClient client = ((HttpClientResources)this.acquiredResourcesRef.get()).client;
        Request req = client.newRequest(url).method("PUT");
        Duration effectiveTimeout = request.tikaServerTimeoutSeconds != null && request.tikaServerTimeoutSeconds > 0 ? Duration.ofSeconds(request.tikaServerTimeoutSeconds.intValue()) : this.defaultTimeout;
        req.timeout(effectiveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        String accept = request.tikaServerRecursive ? "application/json" : "text/xml";
        req.headers(h -> h.add("Accept", accept));
        String string = contentType = request.streamType != null ? request.streamType : request.contentType;
        if (contentType != null) {
            req.headers(h -> h.add("Content-Type", contentType));
        }
        if (!request.tikaServerRequestHeaders.isEmpty()) {
            req.headers(h -> request.tikaServerRequestHeaders.forEach((k, v) -> {
                if (k != null && v != null) {
                    h.add(k, v);
                }
            }));
        }
        ExtractionMetadata md = this.buildMetadataFromRequest(request);
        if (request.resourcePassword != null || request.passwordsMap != null) {
            String pwd;
            RegexRulesPasswordProvider passwordProvider = new RegexRulesPasswordProvider();
            if (request.resourcePassword != null) {
                passwordProvider.setExplicitPassword(request.resourcePassword);
            }
            if (request.passwordsMap != null) {
                passwordProvider.setPasswordMap(request.passwordsMap);
            }
            if ((pwd = passwordProvider.getPassword(md)) != null) {
                req.headers(h -> h.add("Password", pwd));
            }
        }
        if (request.resourceName != null) {
            req.headers(h -> h.add("Content-Disposition", "attachment; filename=\"" + request.resourceName + "\""));
        }
        if (contentType != null) {
            req.body((Request.Content)new InputStreamRequestContent(contentType, inputStream));
        } else {
            req.body((Request.Content)new InputStreamRequestContent(inputStream));
        }
        InputStreamResponseListener listener = new InputStreamResponseListener();
        req.send((Response.CompleteListener)listener);
        try {
            response = listener.get(effectiveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new SolrException(SolrException.ErrorCode.GATEWAY_TIMEOUT, "Timeout after " + effectiveTimeout.toMillis() + " ms while waiting for response from TikaServer " + url, (Throwable)te);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while waiting for response from TikaServer " + url, (Throwable)ie);
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            if (cause instanceof ConnectException || cause instanceof SocketTimeoutException || cause instanceof EofException || cause instanceof ClosedChannelException) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Error communicating with TikaServer " + url + ": " + cause.getClass().getSimpleName() + ": " + cause.getMessage(), cause);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected error while calling TikaServer " + url, (Throwable)ee);
        }
        int code = response.getStatus();
        if (code < 200 || code >= 300) {
            SolrException.ErrorCode errorCode = SolrException.ErrorCode.getErrorCode((int)code);
            String reason = response.getReason();
            String msg = "TikaServer " + url + " returned status " + code + (String)(reason != null ? " (" + reason + ")" : "");
            throw new SolrException(errorCode, msg);
        }
        InputStream responseStream = listener.getInputStream();
        return new LimitingInputStream(responseStream, this.maxCharsLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RefCounted<HttpClientResources> initializeHttpClient() {
        RefCounted<HttpClientResources> ref = SHARED_RESOURCES;
        if (ref != null) {
            return ref;
        }
        Object object = INIT_LOCK;
        synchronized (object) {
            if (SHARED_RESOURCES != null) {
                return SHARED_RESOURCES;
            }
            SolrNamedThreadFactory tf = new SolrNamedThreadFactory("TikaServerHttpClient");
            ExecutorService exec = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)tf);
            HttpClient client = new HttpClient();
            client.setExecutor((Executor)exec);
            client.setScheduler((Scheduler)new ScheduledExecutorScheduler("TikaServerHttpClient-scheduler", true));
            try {
                client.start();
            }
            catch (Exception e) {
                try {
                    exec.shutdownNow();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to start shared Jetty HttpClient", (Throwable)e);
            }
            SHARED_RESOURCES = new ResourcesRef(new HttpClientResources(client, exec));
            return SHARED_RESOURCES;
        }
    }

    private void appendBackCompatTikaMetadata(ExtractionMetadata md) {
        for (Map.Entry<String, String> mapping : this.fieldMappings.entrySet()) {
            String sourceField = mapping.getKey();
            String targetField = mapping.getValue();
            if (md.getFirst(sourceField) == null || md.getFirst(targetField) != null) continue;
            md.add(targetField, md.get(sourceField));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RefCounted<HttpClientResources> ref;
        Object object = INIT_LOCK;
        synchronized (object) {
            ref = this.acquiredResourcesRef;
            this.acquiredResourcesRef = null;
        }
        if (ref != null) {
            ref.decref();
        }
    }

    private static final class ResourcesRef
    extends RefCounted<HttpClientResources> {
        ResourcesRef(HttpClientResources r) {
            super((Object)r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            try {
                if (((HttpClientResources)this.resource).client != null) {
                    ((HttpClientResources)this.resource).client.stop();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (((HttpClientResources)this.resource).executor != null) {
                    ((HttpClientResources)this.resource).executor.shutdownNow();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Object object = INIT_LOCK;
            synchronized (object) {
                if (SHARED_RESOURCES == this) {
                    SHARED_RESOURCES = null;
                }
            }
        }
    }

    private static final class HttpClientResources {
        final HttpClient client;
        final ExecutorService executor;

        HttpClientResources(HttpClient client, ExecutorService executor) {
            this.client = client;
            this.executor = executor;
        }
    }

    private static class LimitingInputStream
    extends InputStream {
        private final InputStream in;
        private final long max;
        private long count;

        LimitingInputStream(InputStream in, long max) {
            this.in = in;
            this.max = max;
            this.count = 0L;
        }

        private void checkLimit(long toAdd) {
            if (this.max <= 0L) {
                return;
            }
            long newCount = this.count + toAdd;
            if (newCount > this.max) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "TikaServer response exceeded the configured maximum size of " + this.max + " bytes");
            }
            this.count = newCount;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                this.checkLimit(1L);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.checkLimit(n);
            }
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = this.in.skip(n);
            if (skipped > 0L) {
                this.checkLimit(skipped);
            }
            return skipped;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }
    }
}

