/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.fst;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.BlendedInfixSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.fst.AnalyzingInfixLookupFactory;

public class BlendedInfixLookupFactory
extends AnalyzingInfixLookupFactory {
    private static final String BLENDER_TYPE = "blenderType";
    private static final String EXPONENT = "exponent";
    private static final String NUM_FACTOR = "numFactor";
    private static final String DEFAULT_INDEX_PATH = "blendedInfixSuggesterIndexDir";
    private static final String FILENAME = "bifsta.bin";

    @Override
    public Lookup create(NamedList<?> params, SolrCore core) {
        Object indexPath;
        Object fieldTypeName = params.get("suggestAnalyzerFieldType");
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getLatestSchema().getFieldTypeByName(fieldTypeName.toString());
        if (ft == null) {
            throw new IllegalArgumentException("Error in configuration: " + fieldTypeName.toString() + " is not defined in the schema");
        }
        Analyzer indexAnalyzer = ft.getIndexAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        Object object = indexPath = params.get("indexPath") != null ? params.get("indexPath").toString() : DEFAULT_INDEX_PATH;
        if (!new File((String)indexPath).isAbsolute()) {
            indexPath = core.getDataDir() + File.separator + (String)indexPath;
        }
        int minPrefixChars = params.get("minPrefixChars") != null ? Integer.parseInt(params.get("minPrefixChars").toString()) : 4;
        boolean allTermsRequired = params.get("allTermsRequired") != null ? Boolean.getBoolean(params.get("allTermsRequired").toString()) : true;
        boolean highlight = params.get("highlight") != null ? Boolean.getBoolean(params.get("highlight").toString()) : true;
        BlendedInfixSuggester.BlenderType blenderType = this.getBlenderType(params.get(BLENDER_TYPE));
        int numFactor = params.get(NUM_FACTOR) != null ? Integer.parseInt(params.get(NUM_FACTOR).toString()) : BlendedInfixSuggester.DEFAULT_NUM_FACTOR;
        Double exponent = params.get(EXPONENT) == null ? null : Double.valueOf(params.get(EXPONENT).toString());
        try {
            return new BlendedInfixSuggester((Directory)FSDirectory.open((Path)new File((String)indexPath).toPath()), indexAnalyzer, queryAnalyzer, minPrefixChars, blenderType, numFactor, exponent, true, allTermsRequired, highlight){

                public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
                    ArrayList<Lookup.LookupResult> res = super.lookup(key, contexts, num, allTermsRequired, doHighlight);
                    if (doHighlight) {
                        ArrayList<Lookup.LookupResult> res2 = new ArrayList<Lookup.LookupResult>();
                        for (Lookup.LookupResult hit : res) {
                            res2.add(new Lookup.LookupResult((CharSequence)hit.highlightKey.toString(), hit.highlightKey, hit.value, hit.payload, hit.contexts));
                        }
                        res = res2;
                    }
                    return res;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String storeFileName() {
        return FILENAME;
    }

    private BlendedInfixSuggester.BlenderType getBlenderType(Object blenderTypeParam) {
        BlendedInfixSuggester.BlenderType blenderType = BlendedInfixSuggester.BlenderType.POSITION_LINEAR;
        if (blenderTypeParam != null) {
            String blenderTypeStr = blenderTypeParam.toString().toUpperCase(Locale.ROOT);
            blenderType = BlendedInfixSuggester.BlenderType.valueOf((String)blenderTypeStr);
        }
        return blenderType;
    }
}

