/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.ArrayList;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.RealtimeRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.ConfigConstants;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public class ProtectedIndexAccessEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final AuditLog auditLog;
    private final WildcardMatcher indexMatcher;
    private final WildcardMatcher allowedRolesMatcher;
    private final Boolean protectedIndexEnabled;
    private final WildcardMatcher deniedActionMatcher;

    public ProtectedIndexAccessEvaluator(Settings settings, AuditLog auditLog) {
        this.indexMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.protected_indices.indices", ConfigConstants.SECURITY_PROTECTED_INDICES_DEFAULT));
        this.allowedRolesMatcher = WildcardMatcher.from(settings.getAsList("plugins.security.protected_indices.roles", ConfigConstants.SECURITY_PROTECTED_INDICES_ROLES_DEFAULT));
        this.protectedIndexEnabled = settings.getAsBoolean("plugins.security.protected_indices.enabled", ConfigConstants.SECURITY_PROTECTED_INDICES_ENABLED_DEFAULT);
        this.auditLog = auditLog;
        ArrayList<String> indexDeniedActionPatterns = new ArrayList<String>();
        indexDeniedActionPatterns.add("indices:data/write*");
        indexDeniedActionPatterns.add("indices:admin/delete*");
        indexDeniedActionPatterns.add("indices:admin/mapping/delete*");
        indexDeniedActionPatterns.add("indices:admin/mapping/put*");
        indexDeniedActionPatterns.add("indices:admin/freeze*");
        indexDeniedActionPatterns.add("indices:admin/settings/update*");
        indexDeniedActionPatterns.add("indices:admin/aliases");
        indexDeniedActionPatterns.add("indices:admin/close*");
        indexDeniedActionPatterns.add("cluster:admin/snapshot/restore*");
        this.deniedActionMatcher = WildcardMatcher.from(indexDeniedActionPatterns);
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, IndexResolverReplacer.Resolved requestedResolved, PrivilegesEvaluatorResponse presponse, Set<String> mappedRoles) {
        if (!this.protectedIndexEnabled.booleanValue()) {
            return presponse;
        }
        if (!requestedResolved.isLocalAll() && this.indexMatcher.matchAny(requestedResolved.getAllIndices()) && this.deniedActionMatcher.test(action) && !this.allowedRolesMatcher.matchAny(mappedRoles)) {
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
            this.log.warn("{} for '{}' index/indices is not allowed for a regular user", (Object)action, (Object)this.indexMatcher);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (requestedResolved.isLocalAll() && this.deniedActionMatcher.test(action) && !this.allowedRolesMatcher.matchAny(mappedRoles)) {
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request, task);
            this.log.warn("{} for '_all' indices is not allowed for a regular user", (Object)action);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if ((requestedResolved.isLocalAll() || this.indexMatcher.matchAny(requestedResolved.getAllIndices())) && !this.allowedRolesMatcher.matchAny(mappedRoles)) {
            boolean isDebugEnabled = this.log.isDebugEnabled();
            if (request instanceof SearchRequest) {
                ((SearchRequest)request).requestCache(Boolean.FALSE);
                if (isDebugEnabled) {
                    this.log.debug("Disable search request cache for this request");
                }
            }
            if (request instanceof RealtimeRequest) {
                ((RealtimeRequest)request).realtime(Boolean.FALSE.booleanValue());
                if (isDebugEnabled) {
                    this.log.debug("Disable realtime for this request");
                }
            }
        }
        return presponse;
    }
}

