/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kms;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class DiscoveryFilter {
    private final String partition_;
    private final Collection<String> accountIds_;

    public DiscoveryFilter(String partition, String ... accountIds) {
        this(partition, Arrays.asList(accountIds));
    }

    public DiscoveryFilter(String partition, Collection<String> accountIds) {
        if (partition == null || partition.isEmpty()) {
            throw new IllegalArgumentException("Discovery filter cannot be configured without a partition.");
        }
        if (accountIds == null || accountIds.isEmpty()) {
            throw new IllegalArgumentException("Discovery filter cannot be configured without account IDs.");
        }
        if (accountIds.contains(null) || accountIds.contains("")) {
            throw new IllegalArgumentException("Discovery filter cannot be configured with null or empty account IDs.");
        }
        this.partition_ = partition;
        this.accountIds_ = new HashSet<String>(accountIds);
    }

    public String getPartition() {
        return this.partition_;
    }

    public Collection<String> getAccountIds() {
        return Collections.unmodifiableSet(new HashSet<String>(this.accountIds_));
    }

    public boolean allowsPartitionAndAccount(String partition, String accountId) {
        return this.partition_.equals(partition) && this.accountIds_.contains(accountId);
    }
}

