/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.IndexInsight;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.indexInsight.IndexInsightConfig;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightConfigGetRequest;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightConfigGetResponse;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetIndexInsightConfigTransportAction
extends HandledTransportAction<ActionRequest, MLIndexInsightConfigGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetIndexInsightConfigTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public GetIndexInsightConfigTransportAction(TransportService transportService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, MLFeatureEnabledSetting mlFeatureEnabledSetting, Client client, SdkClient sdkClient) {
        super("cluster:admin/opensearch/ml/index_insight_config/get", transportService, actionFilters, MLIndexInsightConfigGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.sdkClient = sdkClient;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLIndexInsightConfigGetResponse> listener) {
        MLIndexInsightConfigGetRequest mlIndexInsightConfigGetRequest = MLIndexInsightConfigGetRequest.fromActionRequest((ActionRequest)request);
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, mlIndexInsightConfigGetRequest.getTenantId(), listener)) {
            return;
        }
        if (!this.mlFeatureEnabledSetting.isIndexInsightEnabled()) {
            listener.onFailure((Exception)new RuntimeException("Index insight feature is not enabled yet. To enable, please update the setting " + MLCommonsSettings.ML_COMMONS_INDEX_INSIGHT_FEATURE_ENABLED.getKey()));
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String docId = Optional.ofNullable(mlIndexInsightConfigGetRequest.getTenantId()).orElse("03000200-0400-0500-0006-000700080009");
            this.sdkClient.getDataObjectAsync(((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().tenantId(mlIndexInsightConfigGetRequest.getTenantId())).index(".plugins-ml-index-insight-config")).id(docId)).build()).whenComplete((r, throwable) -> {
                block14: {
                    context.restore();
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        log.error("Failed to get index insight config", (Throwable)cause);
                        listener.onFailure(cause);
                    } else {
                        try {
                            GetResponse getResponse = r.getResponse();
                            assert (getResponse != null);
                            if (getResponse.isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, getResponse.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    IndexInsightConfig indexInsightConfig = IndexInsightConfig.parse((XContentParser)parser);
                                    MLIndexInsightConfigGetResponse mlIndexInsightConfigGetResponse = new MLIndexInsightConfigGetResponse(indexInsightConfig);
                                    listener.onResponse((Object)mlIndexInsightConfigGetResponse);
                                    break block14;
                                }
                                catch (Exception e) {
                                    listener.onFailure(e);
                                }
                                break block14;
                            }
                            listener.onFailure((Exception)new RuntimeException("Failed to get index insight config"));
                        }
                        catch (Exception e) {
                            listener.onFailure(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to get index insight config", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

