/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.LocalGateway;

public class DescribeLocalGatewaysIterable
implements SdkIterable<DescribeLocalGatewaysResponse> {
    private final Ec2Client client;
    private final DescribeLocalGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLocalGatewaysIterable(Ec2Client client, DescribeLocalGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLocalGatewaysResponseFetcher();
    }

    public Iterator<DescribeLocalGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LocalGateway> localGateways() {
        Function<DescribeLocalGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.localGateways() != null) {
                return response.localGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLocalGatewaysResponseFetcher
    implements SyncPageFetcher<DescribeLocalGatewaysResponse> {
        private DescribeLocalGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLocalGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLocalGatewaysResponse nextPage(DescribeLocalGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeLocalGatewaysIterable.this.client.describeLocalGateways(DescribeLocalGatewaysIterable.this.firstRequest);
            }
            return DescribeLocalGatewaysIterable.this.client.describeLocalGateways((DescribeLocalGatewaysRequest)((Object)DescribeLocalGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

