/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.IOException;
import java.io.InputStream;
import org.hibernate.boot.InvalidMappingException;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;

public class InputStreamXmlSource {
    public static Binding<? extends JaxbBindableMappingDescriptor> fromStream(InputStream inputStream, MappingBinder mappingBinder) {
        JaxbLogger.JAXB_LOGGER.trace("reading mappings from InputStream");
        Origin origin = new Origin(SourceType.INPUT_STREAM, null);
        return InputStreamXmlSource.fromStream(inputStream, origin, false, mappingBinder);
    }

    public static Binding<? extends JaxbBindableMappingDescriptor> fromStream(InputStream stream, Origin origin, boolean autoClose, MappingBinder binder) {
        try {
            Binding binding = binder.bind(stream, origin);
            return binding;
        }
        catch (Exception e) {
            throw new InvalidMappingException(origin, (Throwable)e);
        }
        finally {
            if (autoClose) {
                try {
                    stream.close();
                }
                catch (IOException ignore) {
                    JaxbLogger.JAXB_LOGGER.trace("Was unable to close input stream");
                }
            }
        }
    }
}

