/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.principal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import org.wildfly.common.Assert;

public final class RealmNestedPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 3776427564561628331L;
    private final String r;
    private final Principal p;

    public RealmNestedPrincipal(String realmName, Principal nestedPrincipal) {
        Assert.checkNotNullParam((String)"realmName", (Object)realmName);
        Assert.checkNotNullParam((String)"nestedPrincipal", (Object)nestedPrincipal);
        this.r = realmName;
        this.p = nestedPrincipal;
    }

    public String getRealmName() {
        return this.r;
    }

    public Principal getNestedPrincipal() {
        return this.p;
    }

    public <P extends Principal> P getNestedPrincipal(Class<P> principalClass) {
        return (P)(principalClass.isInstance(this.p) ? (Principal)principalClass.cast(this.p) : null);
    }

    @Override
    public String getName() {
        return this.r + "/" + this.p.getName();
    }

    @Override
    public int hashCode() {
        return this.r.hashCode() * 17 + this.p.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RealmNestedPrincipal && this.equals((RealmNestedPrincipal)obj);
    }

    public boolean equals(RealmNestedPrincipal obj) {
        return this == obj || obj != null && this.r.equals(obj.r) && this.p.equals(obj.p);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.r == null || this.p == null) {
            throw new InvalidObjectException("All fields must be non-null");
        }
    }
}

