/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.control.RequestContextController;
import java.util.concurrent.atomic.AtomicBoolean;

@Dependent
public class InjectableRequestContextController
implements RequestContextController {
    private final ManagedContext requestContext = Arc.container().requestContext();
    private final AtomicBoolean isActivator = new AtomicBoolean(false);

    public boolean activate() {
        if (Arc.container().getActiveContext(RequestScoped.class) != null) {
            return false;
        }
        this.requestContext.activate();
        this.isActivator.set(true);
        return true;
    }

    public void deactivate() throws ContextNotActiveException {
        if (Arc.container().getActiveContext(RequestScoped.class) == null) {
            throw new ContextNotActiveException(RequestScoped.class.getName());
        }
        if (this.isActivator.compareAndSet(true, false)) {
            this.requestContext.terminate();
        }
    }
}

