/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote.transaction;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.common.util.Retry;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.ConditionalRemover;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Expiration;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Updater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.UpdaterFactory;
import org.keycloak.models.sessions.infinispan.transaction.DatabaseUpdate;
import org.keycloak.models.sessions.infinispan.transaction.NonBlockingTransaction;

public class RemoteChangeLogTransaction<K, V, T extends Updater<K, V>, R extends ConditionalRemover<K, V>>
implements NonBlockingTransaction {
    private static final RetryOperationSuccess<?, ?, ?> TO_NULL = (ignored1, ignored2, ignored3) -> CompletableFutures.completedNull();
    private final Map<K, T> entityChanges;
    private final UpdaterFactory<K, V, T> factory;
    private final R conditionalRemover;
    private final SharedState<K, V> sharedState;

    RemoteChangeLogTransaction(UpdaterFactory<K, V, T> factory, SharedState<K, V> sharedState, R conditionalRemover) {
        this.factory = Objects.requireNonNull(factory);
        this.conditionalRemover = (ConditionalRemover)Objects.requireNonNull(conditionalRemover);
        this.sharedState = Objects.requireNonNull(sharedState);
        this.entityChanges = new ConcurrentHashMap<K, T>(8);
    }

    @Override
    public void asyncCommit(AggregateCompletionStage<Void> stage, Consumer<DatabaseUpdate> databaseUpdates) {
        this.conditionalRemover.executeRemovals(this.getCache(), stage);
        for (Updater updater : this.entityChanges.values()) {
            if (updater.isReadOnly() || updater.isTransient() || this.conditionalRemover.willRemove(updater)) continue;
            if (updater.isDeleted()) {
                stage.dependsOn(this.commitRemove(updater));
                continue;
            }
            Expiration expiration = updater.computeExpiration();
            if (expiration.isExpired()) {
                stage.dependsOn(this.commitRemove(updater));
                continue;
            }
            if (updater.isCreated()) {
                stage.dependsOn(this.commitPutIfAbsent(updater, expiration));
                continue;
            }
            if (updater.hasVersion()) {
                stage.dependsOn(this.commitReplace(updater, expiration));
                continue;
            }
            stage.dependsOn(this.commitCompute(updater, expiration));
        }
    }

    @Override
    public void asyncRollback(AggregateCompletionStage<Void> stage) {
        this.entityChanges.clear();
    }

    public RemoteCache<K, V> getCache() {
        return this.sharedState.cache();
    }

    public T get(K key) {
        Updater updater = (Updater)this.entityChanges.get(key);
        if (updater != null) {
            return (T)(updater.isDeleted() ? null : updater);
        }
        return this.onEntityFromCache(key, this.getCache().getWithMetadata(key));
    }

    public CompletionStage<T> getAsync(K key) {
        Updater updater = (Updater)this.entityChanges.get(key);
        if (updater != null) {
            return updater.isDeleted() ? CompletableFutures.completedNull() : CompletableFuture.completedFuture(updater);
        }
        return this.getCache().getWithMetadataAsync(key).thenApply(e -> this.onEntityFromCache(key, (MetadataValue<V>)e));
    }

    public T create(K key, V entity) {
        T updater = this.factory.create(key, entity);
        this.entityChanges.put(key, updater);
        return updater;
    }

    public void remove(K key) {
        Updater updater = (Updater)this.entityChanges.get(key);
        if (updater != null) {
            updater.markDeleted();
            return;
        }
        this.entityChanges.put(key, this.factory.deleted(key));
    }

    R getConditionalRemover() {
        return this.conditionalRemover;
    }

    public T wrap(Map.Entry<K, MetadataValue<V>> entry) {
        return (T)this.entityChanges.computeIfAbsent(entry.getKey(), k -> this.factory.wrapFromCache(k, (MetadataValue)entry.getValue()));
    }

    public T wrap(K key, V value, long version) {
        return (T)this.entityChanges.computeIfAbsent(key, k -> this.factory.wrapFromCache(k, value, version));
    }

    protected Map<K, T> getCachedEntities() {
        return this.entityChanges;
    }

    private T onEntityFromCache(K key, MetadataValue<V> entity) {
        if (entity == null) {
            return null;
        }
        T updater = this.factory.wrapFromCache(key, entity);
        this.entityChanges.put(key, updater);
        return updater.isDeleted() ? null : (T)updater;
    }

    private CompletionStage<Void> commitRemove(Updater<K, V> updater) {
        return this.executeWithRetries(this::invokeCacheRemove, TO_NULL, updater, null, 0);
    }

    private CompletionStage<Void> commitPutIfAbsent(Updater<K, V> updater, Expiration expiration) {
        return this.executeWithRetries(this::invokeCachePutIfAbsent, this::handleBooleanResult, updater, expiration, 0);
    }

    private CompletionStage<Void> commitReplace(Updater<K, V> updater, Expiration expiration) {
        return this.executeWithRetries(this::invokeCacheReplace, this::handleBooleanResult, updater, expiration, 0);
    }

    private CompletionStage<Void> commitCompute(Updater<K, V> updater, Expiration expiration) {
        return this.executeWithRetries(this::invokeCacheCompute, TO_NULL, updater, expiration, 0);
    }

    private CompletionStage<Void> handleBooleanResult(boolean success, Updater<K, V> updater, Expiration expiration) {
        return success ? CompletableFutures.completedNull() : this.commitCompute(updater, expiration);
    }

    private CompletionStage<V> invokeCacheRemove(Updater<K, V> updater, Expiration ignored) {
        return this.getCache().removeAsync(updater.getKey());
    }

    private CompletionStage<Boolean> invokeCachePutIfAbsent(Updater<K, V> updater, Expiration expiration) {
        return this.getCache().withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsentAsync(updater.getKey(), updater.getValue(), expiration.lifespan(), TimeUnit.MILLISECONDS, expiration.maxIdle(), TimeUnit.MILLISECONDS).thenApply(Objects::isNull);
    }

    private CompletionStage<Boolean> invokeCacheReplace(Updater<K, V> updater, Expiration expiration) {
        return this.getCache().replaceWithVersionAsync(updater.getKey(), updater.getValue(), updater.getVersionRead(), expiration.lifespan(), TimeUnit.MILLISECONDS, expiration.maxIdle(), TimeUnit.MILLISECONDS);
    }

    private CompletionStage<V> invokeCacheCompute(Updater<K, V> updater, Expiration expiration) {
        return this.getCache().computeIfPresentAsync(updater.getKey(), updater, expiration.lifespan(), TimeUnit.MILLISECONDS, expiration.maxIdle(), TimeUnit.MILLISECONDS);
    }

    private <OR> CompletionStage<Void> executeWithRetries(RetryOperation<OR, K, V> operation, RetryOperationSuccess<OR, K, V> onSuccessAction, Updater<K, V> updater, Expiration expiration, int retry) {
        return operation.execute(updater, expiration).handle((result, throwable) -> this.handleOperationResult((Object)result, (Throwable)throwable, operation, onSuccessAction, updater, expiration, retry)).thenCompose(CompletableFutures.identity());
    }

    private <OR> CompletionStage<Void> handleOperationResult(OR result, Throwable throwable, RetryOperation<OR, K, V> operation, RetryOperationSuccess<OR, K, V> onSuccessAction, Updater<K, V> updater, Expiration expiration, int retry) {
        if (throwable == null) {
            return onSuccessAction.onSuccess(result, updater, expiration);
        }
        if (retry >= this.sharedState.maxRetries()) {
            return CompletableFuture.failedFuture(CompletableFutures.extractException((Throwable)throwable));
        }
        return this.backOffAndExecuteWithRetries(operation, onSuccessAction, updater, expiration, retry + 1);
    }

    private <OR> CompletionStage<Void> backOffAndExecuteWithRetries(RetryOperation<OR, K, V> operation, RetryOperationSuccess<OR, K, V> onSuccessAction, Updater<K, V> updater, Expiration expiration, int retry) {
        int delayMillis = Retry.computeBackoffInterval((int)this.sharedState.backOffBaseTimeMillis(), (int)retry);
        return this.sharedState.blockingManager().scheduleRunBlocking(() -> this.executeWithRetries(operation, onSuccessAction, updater, expiration, retry), (long)delayMillis, TimeUnit.MILLISECONDS, (Object)("retry-" + String.valueOf(updater))).thenCompose(CompletableFutures.identity());
    }

    public static interface SharedState<K, V> {
        public RemoteCache<K, V> cache();

        public int maxRetries();

        public int backOffBaseTimeMillis();

        public BlockingManager blockingManager();
    }

    private static interface RetryOperation<R, K, V> {
        public CompletionStage<R> execute(Updater<K, V> var1, Expiration var2);
    }

    private static interface RetryOperationSuccess<R, K, V> {
        public CompletionStage<Void> onSuccess(R var1, Updater<K, V> var2, Expiration var3);
    }
}

