/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.Options;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

public class ImageImporter
extends FileImporter {
    private static final Pattern URL_START_BAD = Pattern.compile("^(https?:/)([^/].*)$");
    private static final Pattern URL_START_GOOD = Pattern.compile("^https?://.*$");
    private GpxLayer gpx;
    public static final List<String> SUPPORTED_FILE_TYPES = Collections.unmodifiableList(Arrays.stream(ImageIO.getReaderFileSuffixes()).sorted().collect(Collectors.toList()));
    public static final ExtensionFileFilter FILE_FILTER = ImageImporter.getFileFilters(false);
    public static final ExtensionFileFilter FILE_FILTER_WITH_FOLDERS = ImageImporter.getFileFilters(true);

    private static ExtensionFileFilter getFileFilters(boolean folder) {
        String typeStr = String.join((CharSequence)",", SUPPORTED_FILE_TYPES);
        String humanStr = I18n.tr("Image Files", new Object[0]) + " (*." + String.join((CharSequence)", *.", SUPPORTED_FILE_TYPES);
        if (folder) {
            humanStr = humanStr + ", " + I18n.tr("folder", new Object[0]);
        }
        humanStr = humanStr + ")";
        return new ExtensionFileFilter(typeStr, "jpg", humanStr);
    }

    public ImageImporter() {
        this(false);
    }

    public ImageImporter(boolean includeFolders) {
        super(includeFolders ? FILE_FILTER_WITH_FOLDERS : FILE_FILTER);
    }

    public ImageImporter(GpxLayer gpx) {
        this(true);
        this.gpx = gpx;
    }

    @Override
    public boolean acceptFile(File pathname) {
        return super.acceptFile(pathname) || pathname.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(List<File> sel, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        progressMonitor.beginTask(I18n.tr("Looking for image files", new Object[0]), 1);
        try {
            ArrayList<File> files = new ArrayList<File>();
            HashSet<String> visitedDirs = new HashSet<String>();
            ImageImporter.addRecursiveFiles(this.options, files, visitedDirs, sel, progressMonitor.createSubTaskMonitor(1, true));
            if (progressMonitor.isCanceled()) {
                return;
            }
            if (files.isEmpty()) {
                throw new IOException(I18n.tr("No image files found.", new Object[0]));
            }
            GeoImageLayer.create(files, this.gpx);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    static void addRecursiveFiles(List<File> files, Set<String> visitedDirs, List<File> sel, ProgressMonitor progressMonitor) throws IOException {
        ImageImporter.addRecursiveFiles(EnumSet.noneOf(Options.class), files, visitedDirs, sel, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addRecursiveFiles(Set<Options> options, List<File> files, Set<String> visitedDirs, List<File> sel, ProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor.isCanceled()) {
            return;
        }
        progressMonitor.beginTask(null, sel.size());
        try {
            for (File f : sel) {
                if (f.isDirectory()) {
                    if (visitedDirs.add(f.getCanonicalPath())) {
                        File[] dirFiles = f.listFiles();
                        if (dirFiles == null) continue;
                        ImageImporter.addRecursiveFiles(options, files, visitedDirs, Arrays.asList(dirFiles), progressMonitor.createSubTaskMonitor(1, true));
                        continue;
                    }
                    progressMonitor.worked(1);
                    continue;
                }
                String path = f.getPath();
                Matcher matcherBad = URL_START_BAD.matcher(path);
                String realPath = matcherBad.matches() ? matcherBad.replaceFirst(matcherBad.group(1) + "/" + matcherBad.group(2)) : path;
                if (URL_START_GOOD.matcher(realPath).matches() && FILE_FILTER.accept(f) && options.contains((Object)Options.ALLOW_WEB_RESOURCES)) {
                    try (CachedFile cachedFile = new CachedFile(realPath);){
                        files.add(cachedFile.getFile());
                    }
                } else if (FILE_FILTER.accept(f)) {
                    files.add(f);
                }
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public boolean isBatchImporter() {
        return true;
    }

    @Override
    public double getPriority() {
        return -1000.0;
    }
}

