/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;

public abstract class DocValuesSkipper {
    public abstract void advance(int var1) throws IOException;

    public abstract int numLevels();

    public abstract int minDocID(int var1);

    public abstract int maxDocID(int var1);

    public abstract long minValue(int var1);

    public abstract long maxValue(int var1);

    public abstract int docCount(int var1);

    public abstract long minValue();

    public abstract long maxValue();

    public abstract int docCount();

    public final void advance(long minValue, long maxValue) throws IOException {
        if (this.minDocID(0) == -1) {
            this.advance(0);
        }
        while (this.minDocID(0) != Integer.MAX_VALUE && (this.minValue(0) > maxValue || this.maxValue(0) < minValue)) {
            int maxDocID = this.maxDocID(0);
            for (int nextLevel = 1; nextLevel < this.numLevels() && (this.minValue(nextLevel) > maxValue || this.maxValue(nextLevel) < minValue); ++nextLevel) {
                maxDocID = this.maxDocID(nextLevel);
            }
            this.advance(maxDocID + 1);
        }
    }

    public static long globalMinValue(IndexSearcher searcher, String field) throws IOException {
        long minValue = Long.MAX_VALUE;
        for (LeafReaderContext ctx : searcher.getLeafContexts()) {
            if (ctx.reader().getFieldInfos().fieldInfo(field) == null) continue;
            DocValuesSkipper skipper = ctx.reader().getDocValuesSkipper(field);
            if (skipper == null) {
                return Long.MIN_VALUE;
            }
            minValue = Math.min(minValue, skipper.minValue());
        }
        return minValue;
    }

    public static long globalMaxValue(IndexSearcher searcher, String field) throws IOException {
        long maxValue = Long.MIN_VALUE;
        for (LeafReaderContext ctx : searcher.getLeafContexts()) {
            if (ctx.reader().getFieldInfos().fieldInfo(field) == null) continue;
            DocValuesSkipper skipper = ctx.reader().getDocValuesSkipper(field);
            if (skipper == null) {
                return Long.MAX_VALUE;
            }
            maxValue = Math.max(maxValue, skipper.maxValue());
        }
        return maxValue;
    }

    public static int globalDocCount(IndexSearcher searcher, String field) throws IOException {
        int docCount = 0;
        for (LeafReaderContext ctx : searcher.getLeafContexts()) {
            DocValuesSkipper skipper = ctx.reader().getDocValuesSkipper(field);
            if (skipper == null) continue;
            docCount += skipper.docCount();
        }
        return docCount;
    }
}

