---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Artifact report types for test results, security scans, code quality checks, and performance metrics.
title: GitLab CI/CD artifacts reports types
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

Use [`artifacts:reports`](_index.md#artifactsreports) to:

- Collect test reports, code quality reports, security reports, and other artifacts generated by included templates in
  jobs.
- Some of these reports are used to display information in:
  - Merge requests.
  - Pipeline views.
  - [Security dashboards](../../user/application_security/security_dashboard/_index.md).

Artifacts created for `artifacts: reports` are always uploaded, regardless of the job results (success or failure).
You can use [`artifacts:expire_in`](_index.md#artifactsexpire_in) to set an expiration
time for the artifacts, which overrides the instance's [default setting](../../administration/settings/continuous_integration.md#set-maximum-artifacts-size).
GitLab.com might have a [different default artifacts expiry value](../../user/gitlab_com/_index.md#cicd).

Some `artifacts:reports` types can be generated by multiple jobs in the same pipeline, and used by merge request or
pipeline features from each job.

To browse the report output files, ensure you include the [`artifacts:paths`](_index.md#artifactspaths) keyword in your job definition.

{{< alert type="note" >}}

Combined reports in parent pipelines using [artifacts from child pipelines](_index.md#needspipelinejob) is
not supported. Support for this feature is proposed in [epic 8205](https://gitlab.com/groups/gitlab-org/-/epics/8205).

{{< /alert >}}

## `artifacts:reports:accessibility`

The `accessibility` report uses [pa11y](https://pa11y.org/) to report on the accessibility impact
of changes introduced in merge requests.

GitLab can display the results of one or more reports in the merge request
[accessibility widget](../testing/accessibility_testing.md#accessibility-merge-request-widget).

For more information, see [Accessibility testing](../testing/accessibility_testing.md).

## `artifacts:reports:annotations`

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/38337) in GitLab 16.3.

{{< /history >}}

The `annotations` report is used to attach auxiliary data to a job.

An annotations report is a JSON file with annotation sections. Each annotation
section can have any desired name and can have any number of annotations of the
same or differing types.

Each annotation is a single key (the annotation type), containing the subkeys with
the data for that annotation.

### Annotation types

#### `external_link`

An `external_link` annotation can be attached to a job to add a link to the job
output page. The value of an `external_link` annotation is an object with the
following keys:

| Key     | Description |
|---------|-------------|
| `label` | The human-readable label associated with the link. |
| `url`   | The URL pointed to by the link. |

### Example report

The following is an example of what a job annotations report might look like:

```json
{
  "my_annotation_section_1": [
    {
      "external_link": {
        "label": "URL 1",
        "url": "https://url1.example.com/"
      }
    },
    {
      "external_link": {
        "label": "URL 2",
        "url": "https://url2.example.com/"
      }
    }
  ]
}
```

## `artifacts:reports:api_fuzzing`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

The `api_fuzzing` report collects [API Fuzzing bugs](../../user/application_security/api_fuzzing/_index.md)
as artifacts.

GitLab can display the results of one or more reports in:

- The merge request [security widget](../../user/application_security/api_fuzzing/configuration/enabling_the_analyzer.md#view-details-of-an-api-fuzzing-vulnerability).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/_index.md).
- The pipeline [**Security** tab](../../user/application_security/detect/security_scanning_results.md).
- The [security dashboard](../../user/application_security/api_fuzzing/configuration/enabling_the_analyzer.md#security-dashboard).

## `artifacts:reports:browser_performance`

{{< details >}}

- Tier: Premium, Ultimate

{{< /details >}}

The `browser_performance` report collects [Browser Performance Testing metrics](../testing/browser_performance_testing.md)
as an artifact. This artifact is a JSON file output by the [Sitespeed plugin](https://gitlab.com/gitlab-org/gl-performance).

GitLab can display the results of one report in the merge request
[browser performance testing widget](../testing/browser_performance_testing.md#how-browser-performance-testing-works).

GitLab cannot display the combined results of multiple `browser_performance` reports.

## `artifacts:reports:coverage_report`

Use `coverage_report:` to collect [coverage report](../testing/_index.md) in Cobertura or JaCoCo formats.

The `coverage_format:` Can be either [`cobertura`](../testing/code_coverage/cobertura.md) or
[`jacoco`](../testing/code_coverage/jacoco.md).

Cobertura was originally developed for Java, but there are many third-party ports for other languages such as
JavaScript, Python, and Ruby.

```yaml
artifacts:
  reports:
    coverage_report:
      coverage_format: cobertura
      path: coverage/cobertura-coverage.xml
```

The collected coverage report is uploaded to GitLab as an artifact.

You can generate multiple JaCoCo or Cobertura reports and include them in the final
job artifact using [wildcards](../jobs/job_artifacts.md#with-wildcards).
The results of the reports are aggregated in the final coverage report.

The results of coverage reports appear in merge request [diff annotations](../testing/code_coverage/_index.md#coverage-visualization).

{{< alert type="note" >}}

Coverage reports from child pipelines appear in merge request diff annotations,
but the artifacts themselves are not shared with parent pipelines.

{{< /alert >}}

## `artifacts:reports:codequality`

The `codequality` report collects [code quality issues](../testing/code_quality.md). The
collected code quality report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [code quality widget](../testing/code_quality.md#merge-request-widget).
- The merge request [diff annotations](../testing/code_quality.md#merge-request-changes-view).
- The [full report](../testing/metrics_reports.md).

The [`artifacts:expire_in`](_index.md#artifactsexpire_in) value is set to `1 week`.

## `artifacts:reports:container_scanning`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

The `container_scanning` report collects [container scanning vulnerabilities](../../user/application_security/container_scanning/_index.md).
The collected container scanning report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [container scanning widget](../../user/application_security/container_scanning/_index.md).
- The pipeline [**Security** tab](../../user/application_security/detect/security_scanning_results.md).
- The [security dashboard](../../user/application_security/security_dashboard/_index.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/_index.md).

## `artifacts:reports:coverage_fuzzing`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

The `coverage_fuzzing` report collects [coverage fuzzing bugs](../../user/application_security/coverage_fuzzing/_index.md).
The collected coverage fuzzing report uploads to GitLab as an artifact.
GitLab can display the results of one or more reports in:

- The merge request [coverage fuzzing widget](../../user/application_security/coverage_fuzzing/_index.md#interacting-with-the-vulnerabilities).
- The pipeline [**Security** tab](../../user/application_security/detect/security_scanning_results.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/_index.md).
- The [security dashboard](../../user/application_security/security_dashboard/_index.md).

## `artifacts:reports:cyclonedx`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

This report is a Software Bill of Materials describing the components of a project
following the [CycloneDX](https://cyclonedx.org/docs/1.4) protocol format.

You can specify multiple CycloneDX reports per job. These can be either supplied
as a list of filenames, a filename pattern, or both:

- A filename pattern (`cyclonedx: gl-sbom-*.json`, `junit: test-results/**/*.json`).
- An array of filenames (`cyclonedx: [gl-sbom-npm-npm.cdx.json, gl-sbom-bundler-gem.cdx.json]`).
- A combination of both (`cyclonedx: [gl-sbom-*.json, my-cyclonedx.json]`).
- Directories are not supported(`cyclonedx: test-results`, `cyclonedx: test-results/**`).

The following example shows a job that exposes CycloneDX artifacts:

```yaml
artifacts:
  reports:
    cyclonedx:
      - gl-sbom-npm-npm.cdx.json
      - gl-sbom-bundler-gem.cdx.json
```

## `artifacts:reports:dast`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

The `dast` report collects [DAST vulnerabilities](../../user/application_security/dast/_index.md). The collected DAST
report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request security widget.
- The pipeline [**Security** tab](../../user/application_security/detect/security_scanning_results.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/_index.md).
- The [security dashboard](../../user/application_security/security_dashboard/_index.md).

## `artifacts:reports:dependency_scanning`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

The `dependency_scanning` report collects [Dependency Scanning vulnerabilities](../../user/application_security/dependency_scanning/_index.md).
The collected Dependency Scanning report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in:

- The merge request [dependency scanning widget](../../user/application_security/dependency_scanning/_index.md).
- The pipeline [**Security** tab](../../user/application_security/detect/security_scanning_results.md).
- The [security dashboard](../../user/application_security/security_dashboard/_index.md).
- The [Project Vulnerability report](../../user/application_security/vulnerability_report/_index.md).
- The [dependency list](../../user/application_security/dependency_list/_index.md).

## `artifacts:reports:dotenv`

The `dotenv` report collects a set of environment variables as artifacts.

The collected variables are registered as runtime-created variables of the job,
which you can [use in subsequent job scripts](../variables/job_scripts.md#pass-an-environment-variable-to-another-job)
or to [set dynamic environment URLs after a job finishes](../environments/_index.md#set-a-dynamic-environment-url).

If duplicate environment variables are present in a `dotenv` report, the last one specified is used.

You should avoid storing sensitive data like credentials in dotenv reports, as the
reports can be downloaded from the pipeline details page. If necessary, you can use
[`artifacts:access`](_index.md#artifactsaccess) to restrict the users that can download
the report artifacts in a job.

GitLab uses the [`dotenv` gem](https://github.com/bkeepers/dotenv) for handling dotenv files,
but applies additional restrictions beyond both [the original dotenv rules](https://github.com/motdotla/dotenv?tab=readme-ov-file#what-rules-does-the-parsing-engine-follow) and the gem's implementation:

- The maximum size of the dotenv file is 5 KB.
  This limit [can be changed on GitLab Self-Managed](../../administration/instance_limits.md#limit-dotenv-file-size).
- On GitLab.com, [the maximum number of inherited variables](../../user/gitlab_com/_index.md#cicd)
  is 50 for Free, 100 for Premium, and 150 for Ultimate. The default for
  GitLab Self-Managed is 20, and can be changed with the
  `dotenv_variables` [application limit](../../administration/instance_limits.md#limit-dotenv-variables).
- Only UTF-8 encoding is [supported](../jobs/job_artifacts_troubleshooting.md#error-message-fatal-invalid-argument-when-uploading-a-dotenv-artifact-on-a-windows-runner).
- The dotenv file cannot contain empty lines or comments (starting with `#`).
- The variable name can contain only ASCII letters (`A-Za-z`), digits (`0-9`), and underscores (`_`).
- The dotenv file does not support quoting. Single or double quotes are preserved as-is and cannot be used for escaping.
  - [Multiline values in the dotenv file](https://github.com/motdotla/dotenv#multiline-values) are not supported.
    GitLab rejects the dotenv file on upload.
  - Leading and trailing spaces or newline characters (`\n`) are stripped.
- Variable substitution (`${var}`) in the dotenv file is not supported.
  GitLab resolves variable substitutions to empty strings when the file is processed.

## `artifacts:reports:junit`

The `junit` report collects [JUnit report format XML files](https://www.ibm.com/docs/en/developer-for-zos/16.0?topic=formats-junit-xml-format).
The collected Unit test reports upload to GitLab as an artifact. Although JUnit was originally developed in Java, there
are many third-party ports for other languages such as JavaScript, Python, and Ruby.

See [Unit test reports](../testing/unit_test_reports.md) for more details and examples.
The following example shows how to collect a JUnit XML report from Ruby RSpec tests:

```yaml
rspec:
  stage: test
  script:
    - bundle install
    - rspec --format RspecJunitFormatter --out rspec.xml
  artifacts:
    reports:
      junit: rspec.xml
```

GitLab can display the results of one or more reports in:

- The merge request [**Test summary** panel](../testing/unit_test_reports.md#view-test-results-in-merge-requests).
- The [pipeline **Tests** tab](../testing/unit_test_reports.md#view-test-results-in-pipelines).

Some JUnit tools export to multiple XML files. You can specify multiple test report paths in a single job to
concatenate them into a single file. Use either:

- A filename pattern (`junit: rspec-*.xml`, `junit: test-results/**/*.xml`).
- An array of filenames (`junit: [rspec-1.xml, rspec-2.xml, rspec-3.xml]`).
- A combination of both (`junit: [rspec.xml, test-results/TEST-*.xml]`).
- Directories are not supported(`junit: test-results`, `junit: test-results/**`).

## `artifacts:reports:load_performance`

{{< details >}}

- Tier: Premium, Ultimate

{{< /details >}}

The `load_performance` report collects [Load Performance Testing metrics](../testing/load_performance_testing.md).
The report is uploaded to GitLab as an artifact.

GitLab can display the results of only one report in the merge request
[load testing widget](../testing/load_performance_testing.md#how-load-performance-testing-works).

GitLab cannot display the combined results of multiple `load_performance` reports.

## `artifacts:reports:metrics`

{{< details >}}

- Tier: Premium, Ultimate

{{< /details >}}

The `metrics` report collects [Metrics](../testing/metrics_reports.md). The collected Metrics report uploads to GitLab as an
artifact.

GitLab can display the results of one or more reports in the merge request
[metrics reports widget](../testing/metrics_reports.md).

## `artifacts:reports:requirements`

{{< details >}}

- Tier: Ultimate

{{< /details >}}

The `requirements` report collects `requirements.json` files. The collected Requirements report uploads to GitLab as an
artifact and existing [requirements](../../user/project/requirements/_index.md) are marked as Satisfied.

GitLab can display the results of one or more reports in the
[project requirements](../../user/project/requirements/_index.md#view-a-requirement).

## `artifacts:reports:sast`

The `sast` report collects [SAST vulnerabilities](../../user/application_security/sast/_index.md).
The collected SAST report uploads to GitLab as an artifact.

For more information, see:

- [View SAST results](../../user/application_security/sast/_index.md#understanding-the-results)
- [SAST output](../../user/application_security/sast/_index.md#download-a-sast-report)

## `artifacts:reports:secret_detection`

The `secret-detection` report collects [detected secrets](../../user/application_security/secret_detection/pipeline/_index.md).
The collected Secret Detection report is uploaded to GitLab.

GitLab can display the results of one or more reports in:

- The merge request [secret scanning widget](../../user/application_security/secret_detection/pipeline/_index.md).
- The [pipeline security tab](../../user/application_security/detect/security_scanning_results.md).
- The [security dashboard](../../user/application_security/security_dashboard/_index.md).

## `artifacts:reports:terraform`

The `terraform` report obtains an OpenTofu `tfplan.json` file. [JQ processing required to remove credentials](../../user/infrastructure/iac/mr_integration.md#configure-opentofu-report-artifacts).
The collected OpenTofu plan report uploads to GitLab as an artifact.

GitLab can display the results of one or more reports in the merge request
[OpenTofu widget](../../user/infrastructure/iac/mr_integration.md#output-opentofu-plan-information-into-a-merge-request).

For more information, see [Output `tofu plan` information into a merge request](../../user/infrastructure/iac/mr_integration.md).
