/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.macos;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.OpenURIEvent;
import java.awt.desktop.OpenURIHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.ViewController;
import org.freeplane.main.application.MacOptions;

public class MacChanges
implements AboutHandler,
OpenFilesHandler,
PreferencesHandler,
OpenURIHandler,
QuitHandler {
    private static Desktop fmMacApplication;
    private final Controller controller;
    private static final Predicate<Window> toggleFullScreenMethod;
    private static final Map<Window, Boolean> fullScreenStates;
    private static Object fullScreenListener;

    private static Predicate<Window> getToggleFullScreenMethod() {
        try {
            Class<?> app = Class.forName("com.apple.eawt.Application");
            Object application = app.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
            Method toggleFullScreenMethod = application.getClass().getMethod("requestToggleFullScreen", Window.class);
            return window -> {
                try {
                    toggleFullScreenMethod.invoke(application, window);
                    return true;
                }
                catch (Exception e) {
                    LogUtils.severe((Throwable)e);
                    return false;
                }
            };
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
            return window -> false;
        }
    }

    public static void apply(Controller controller) {
        new MacChanges(controller);
    }

    public static void setFullScreen(JFrame window, boolean requestFullScreen) {
        boolean hasFullScreen = fullScreenStates.getOrDefault(window, false);
        if (hasFullScreen != requestFullScreen) {
            toggleFullScreenMethod.test(window);
        }
    }

    public static void registerFullScreenListenerForWindow(JFrame window) {
        if (fullScreenListener == null) {
            return;
        }
        try {
            Class<?> fullScreenUtilities = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class<?> fullScreenListenerClass = Class.forName("com.apple.eawt.FullScreenListener");
            fullScreenUtilities.getMethod("addFullScreenListenerTo", Window.class, fullScreenListenerClass).invoke(null, window, fullScreenListener);
        }
        catch (Exception e) {
            LogUtils.warn((String)"Failed to register FullScreenListener for window", (Throwable)e);
        }
    }

    private MacChanges(Controller controller) {
        this.controller = controller;
        if (fmMacApplication == null) {
            String helpMenuTitle = TextUtils.getRawText((String)"menu_help");
            ResourceController resourceController = ResourceController.getResourceController();
            URL macProperties = this.getClass().getResource("freeplane_mac.properties");
            Controller.getCurrentController().getResourceController().addDefaults(macProperties);
            if (resourceController.getBooleanProperty("add_emojis_to_menu")) {
                resourceController.putResourceString("menu_help", helpMenuTitle + " ");
            }
            fmMacApplication = Desktop.getDesktop();
            fmMacApplication.setAboutHandler(this);
            fmMacApplication.setPreferencesHandler(this);
            fmMacApplication.setOpenFileHandler(this);
            fmMacApplication.setOpenURIHandler(this);
            fmMacApplication.setQuitHandler(this);
            this.registerFullScreenListener();
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private MModeController getModeController() {
        return (MModeController)this.controller.getModeController("MindMap");
    }

    @Override
    public void handleQuitRequestWith(QuitEvent event, QuitResponse response) {
        try {
            if (!this.isStarting()) {
                Controller.getCurrentController().quit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.cancelQuit();
    }

    @Override
    public void openURI(OpenURIEvent event) {
        URI uri = event.getURI();
        try {
            if (this.isStarting()) {
                MacOptions.macFilesToOpen.add(uri.toString());
            } else {
                LinkController.getController().loadHyperlink(new Hyperlink(uri));
            }
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
        }
    }

    @Override
    public void handlePreferences(PreferencesEvent event) {
        SwingUtilities.invokeLater(this::showPreferences);
    }

    private void showPreferences() {
        MModeController modeController = this.getModeController();
        if (modeController != null) {
            AFreeplaneAction action = modeController.getAction("ShowPreferencesAction");
            if (action == null) {
                return;
            }
            Component menuComponent = UITools.getCurrentRootComponent();
            if (menuComponent == null || !menuComponent.isShowing()) {
                return;
            }
            action.actionPerformed(null);
        }
    }

    @Override
    public void openFiles(OpenFilesEvent event) {
        for (File file : event.getFiles()) {
            String filePath = file.getPath();
            this.openFile(filePath);
        }
    }

    private void openFile(String filePath) {
        try {
            if (this.isStarting()) {
                MacOptions.macFilesToOpen.add(filePath);
            } else {
                this.getModeController().getMapController().openMap(Compat.fileToUrl((File)new File(filePath)));
            }
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
        }
    }

    private boolean isStarting() {
        return this.controller.getViewController() == null;
    }

    @Override
    public void handleAbout(AboutEvent event) {
        AFreeplaneAction action;
        MModeController modeController = this.getModeController();
        if (modeController != null && (action = modeController.getController().getAction("AboutAction")) != null) {
            action.actionPerformed(null);
        }
    }

    private void registerFullScreenListener() {
        try {
            Object listener;
            Class<?> fullScreenListenerClass = Class.forName("com.apple.eawt.FullScreenListener");
            fullScreenListener = listener = Proxy.newProxyInstance(fullScreenListenerClass.getClassLoader(), new Class[]{fullScreenListenerClass}, (proxy, method, args) -> {
                Object windowEvent;
                Object window;
                if (("windowEnteredFullScreen".equals(method.getName()) || "windowExitedFullScreen".equals(method.getName())) && (window = (windowEvent = args[0]).getClass().getMethod("getWindow", new Class[0]).invoke(windowEvent, new Object[0])) instanceof JFrame) {
                    boolean isFullScreen = "windowEnteredFullScreen".equals(method.getName());
                    fullScreenStates.put((JFrame)window, isFullScreen);
                    ViewController viewController = this.controller.getViewController();
                    if (viewController != null) {
                        viewController.fullScreenToggled((JFrame)window, isFullScreen);
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            LogUtils.warn((String)"Failed to register FullScreenListener", (Throwable)e);
        }
    }

    static {
        toggleFullScreenMethod = MacChanges.getToggleFullScreenMethod();
        fullScreenStates = new ConcurrentHashMap<Window, Boolean>();
    }
}

