/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.util.Map;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.RenamedDataEntry;

public class RenamedDataEntryReader
implements DataEntryReader {
    private final Map nameMap;
    private final DataEntryReader dataEntryReader;
    private final DataEntryReader missingDataEntryReader;

    public RenamedDataEntryReader(Map nameMap, DataEntryReader dataEntryReader) {
        this(nameMap, dataEntryReader, null);
    }

    public RenamedDataEntryReader(Map nameMap, DataEntryReader dataEntryReader, DataEntryReader missingDataEntryReader) {
        this.nameMap = nameMap;
        this.dataEntryReader = dataEntryReader;
        this.missingDataEntryReader = missingDataEntryReader;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        String newName;
        String name = dataEntry.getName();
        if (dataEntry.isDirectory() && name.length() > 0) {
            name = name + '/';
        }
        if ((newName = (String)this.nameMap.get(name)) != null) {
            if (dataEntry.isDirectory() && newName.length() > 0) {
                newName = newName.substring(0, newName.length() - 1);
            }
            this.dataEntryReader.read(new RenamedDataEntry(dataEntry, newName));
        } else if (this.missingDataEntryReader != null) {
            this.missingDataEntryReader.read(dataEntry);
        }
    }
}

