﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront/CloudFront_EXPORTS.h>
#include <aws/cloudfront/model/KeyGroup.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFront {
namespace Model {
class UpdateKeyGroup2020_05_31Result {
 public:
  AWS_CLOUDFRONT_API UpdateKeyGroup2020_05_31Result() = default;
  AWS_CLOUDFRONT_API UpdateKeyGroup2020_05_31Result(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFRONT_API UpdateKeyGroup2020_05_31Result& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The key group that was just updated.</p>
   */
  inline const KeyGroup& GetKeyGroup() const { return m_keyGroup; }
  template <typename KeyGroupT = KeyGroup>
  void SetKeyGroup(KeyGroupT&& value) {
    m_keyGroupHasBeenSet = true;
    m_keyGroup = std::forward<KeyGroupT>(value);
  }
  template <typename KeyGroupT = KeyGroup>
  UpdateKeyGroup2020_05_31Result& WithKeyGroup(KeyGroupT&& value) {
    SetKeyGroup(std::forward<KeyGroupT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for this version of the key group.</p>
   */
  inline const Aws::String& GetETag() const { return m_eTag; }
  template <typename ETagT = Aws::String>
  void SetETag(ETagT&& value) {
    m_eTagHasBeenSet = true;
    m_eTag = std::forward<ETagT>(value);
  }
  template <typename ETagT = Aws::String>
  UpdateKeyGroup2020_05_31Result& WithETag(ETagT&& value) {
    SetETag(std::forward<ETagT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateKeyGroup2020_05_31Result& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  KeyGroup m_keyGroup;
  bool m_keyGroupHasBeenSet = false;

  Aws::String m_eTag;
  bool m_eTagHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
