#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
module: organizations_wireless_devices_radsec_certificates_authorities_crls_deltas_info
short_description: Information module for organizations _wireless _devices _radsec
  _certificates _authorities _crls _deltas
description:
  - Information module for Organizations Wireless Devices Radsec Certificates Authorities Crls Deltas Info.
  - Get all organizations _wireless _devices _radsec _certificates _authorities _crls
    _deltas.
  - >
    Query for all delta certificate revocation list CRL for the organization's RADSEC
    device Certificate Authority CA with the given id.
version_added: '1.0.0'
extends_documentation_fragment:
  - cisco.meraki.module_info
author: Francisco Munoz (@fmunoz)
options:
  headers:
    description: Additional headers.
    type: dict
  organizationId:
    description:
      - Information module for Organizations Wireless Devices Radsec Certificates Authorities Crls Deltas Info.
      - OrganizationId path parameter. Organization ID.
    type: str
  certificateAuthorityIds:
    description:
      - Information module for Organizations Wireless Devices Radsec Certificates Authorities Crls Deltas Info.
      - >
        CertificateAuthorityIds query parameter. Parameter to filter CAs by one or
        more CA IDs. All returned CAs will have an ID that is an exact match.
    elements: str
    type: list
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - name: Cisco Meraki documentation for wireless getOrganizationWirelessDevicesRadsecCertificatesAuthoritiesCrlsDeltas
    description: Complete reference of the getOrganizationWirelessDevicesRadsecCertificatesAuthoritiesCrlsDeltas
      API.
    link: https://developer.cisco.com/meraki/api-v1/#!get-organization-wireless-devices-radsec-certificates-authorities-crls-deltas
notes:
  - SDK Method used are
    wireless.Wireless.get_organization_wireless_devices_radsec_certificates_authorities_crls_deltas,
  - Paths used are
    get /organizations/{organizationId}/wireless/devices/radsec/certificates/authorities/crls/deltas,
"""

EXAMPLES = r"""
- name: Get all organizations _wireless _devices _radsec _certificates _authorities
    _crls _deltas
  cisco.meraki.organizations_wireless_devices_radsec_certificates_authorities_crls_deltas_info:
    meraki_api_key: "{{ meraki_api_key }}"
    meraki_base_url: "{{ meraki_base_url }}"
    meraki_single_request_timeout: "{{ meraki_single_request_timeout }}"
    meraki_certificate_path: "{{ meraki_certificate_path }}"
    meraki_requests_proxy: "{{ meraki_requests_proxy }}"
    meraki_wait_on_rate_limit: "{{ meraki_wait_on_rate_limit }}"
    meraki_nginx_429_retry_wait_time: "{{ meraki_nginx_429_retry_wait_time }}"
    meraki_action_batch_retry_wait_time: "{{ meraki_action_batch_retry_wait_time }}"
    meraki_retry_4xx_error: "{{ meraki_retry_4xx_error }}"
    meraki_retry_4xx_error_wait_time: "{{ meraki_retry_4xx_error_wait_time }}"
    meraki_maximum_retries: "{{ meraki_maximum_retries }}"
    meraki_output_log: "{{ meraki_output_log }}"
    meraki_log_file_prefix: "{{ meraki_log_file_prefix }}"
    meraki_log_path: "{{ meraki_log_path }}"
    meraki_print_console: "{{ meraki_print_console }}"
    meraki_suppress_logging: "{{ meraki_suppress_logging }}"
    meraki_simulate: "{{ meraki_simulate }}"
    meraki_be_geo_id: "{{ meraki_be_geo_id }}"
    meraki_caller: "{{ meraki_caller }}"
    meraki_use_iterator_for_get_pages: "{{ meraki_use_iterator_for_get_pages }}"
    meraki_inherit_logging_config: "{{ meraki_inherit_logging_config }}"
    certificateAuthorityIds: []
    organizationId: string
  register: result
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "items": [
        {
          "certificateAuthorityId": "string",
          "crl": "string"
        }
      ],
      "meta": {
        "counts": {
          "items": {
            "total": 0,
            "remaining": 0
          }
        }
      }
    }
"""
