/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.util.Locale;
import java.util.Map;

public class SensitivePropRedactionUtils {
    private static final String[] PATTERNS_REQUIRING_REDACTION_LOWERCASE = new String[]{"password", "credentials"};
    private static final String REDACTED_STRING = "<REDACTED>";

    public static boolean propertyRequiresRedaction(String propName) {
        String propNameLowercase = propName.toLowerCase(Locale.ROOT);
        for (String pattern : PATTERNS_REQUIRING_REDACTION_LOWERCASE) {
            if (!propNameLowercase.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    public static String redactPropertyIfNecessary(String propName, String propValue) {
        return SensitivePropRedactionUtils.propertyRequiresRedaction(propName) ? REDACTED_STRING : propValue;
    }

    public static String flattenAndRedactForLogging(Map<String, Object> properties) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String printablePropValue = SensitivePropRedactionUtils.redactPropertyIfNecessary(entry.getKey(), String.valueOf(entry.getValue()));
            sb.append(entry.getKey()).append("=").append((Object)printablePropValue).append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

