/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.OpaqueAccessToken;
import oracle.jdbc.logging.annotations.Blind;
import oracle.net.nt.Clock;
import oracle.net.nt.TimeoutInterruptHandler;

final class AccessTokenCache<T extends OpaqueAccessToken>
implements Supplier<T> {
    private static final long EXPIRATION_THRESHOLD = 30000L;
    private static final long UPDATE_THRESHOLD = 60000L;
    private final Supplier<T> tokenSupplier;
    private final Executor executor;
    private final LongSummaryStatistics latency = new LongSummaryStatistics();
    private final AtomicInteger getCount = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition updateCondition = this.lock.newCondition();
    private boolean isUpdating = false;
    private T token = null;
    private RuntimeException failure;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public static <T extends OpaqueAccessToken> AccessTokenCache<T> create(Supplier<T> tokenSupplier) {
        try {
            return new AccessTokenCache<T>(OracleDriver.getExecutorService(), tokenSupplier);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException(sqlException);
        }
    }

    private AccessTokenCache(Executor executor, @Blind Supplier<T> tokenSupplier) {
        this.executor = executor;
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    @Blind
    public T get() {
        this.getCount.incrementAndGet();
        T cachedToken = this.token;
        if (cachedToken != null && !AccessTokenCache.isExpiring(cachedToken)) {
            return cachedToken;
        }
        this.lock.lock();
        try {
            while (cachedToken == this.token && this.failure == null) {
                if (!this.isUpdating) {
                    this.isUpdating = true;
                    this.requestUpdate();
                }
                this.updateCondition.await();
            }
            if (this.failure != null) {
                RuntimeException updateFailure = this.failure;
                this.failure = null;
                throw updateFailure;
            }
            T updateFailure = this.token;
            return updateFailure;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void requestUpdate() {
        this.executor.execute(() -> {
            try {
                long start = System.nanoTime();
                OpaqueAccessToken token = (OpaqueAccessToken)this.tokenSupplier.get();
                this.latency.accept(System.nanoTime() - start);
                this.update(Objects.requireNonNull(token, "token supplier has output a null value"), null);
            }
            catch (RuntimeException failure) {
                this.update(null, failure);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@Blind T token, RuntimeException failure) {
        boolean isUpdating = this.getCount.getAndSet(0) != 0 && failure == null;
        this.lock.lock();
        try {
            this.token = token;
            this.failure = failure;
            this.isUpdating = isUpdating;
            this.updateCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (isUpdating) {
            this.scheduleUpdate(TimeUnit.SECONDS.toMillis(((OpaqueAccessToken)token).expiration().toEpochSecond()));
        }
    }

    private void scheduleUpdate(long expireTimeMillis) {
        long updateLatency = TimeUnit.NANOSECONDS.toMillis(Math.round(this.latency.getAverage() * 1.2));
        long expirationDelay = expireTimeMillis - 60000L - System.currentTimeMillis();
        TimeoutInterruptHandler.scheduleTask(this::requestUpdate, Math.max(0L, expirationDelay - updateLatency));
    }

    private static boolean isExpiring(@Blind OpaqueAccessToken accessToken) {
        return Clock.currentTimeMillis() + 30000L >= TimeUnit.SECONDS.toMillis(accessToken.expiration().toEpochSecond());
    }

    static {
        try {
            $$$methodRef$$$8 = AccessTokenCache.class.getDeclaredConstructor(Executor.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AccessTokenCache.class.getDeclaredMethod("lambda$requestUpdate$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AccessTokenCache.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AccessTokenCache.class.getDeclaredMethod("isExpiring", OpaqueAccessToken.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AccessTokenCache.class.getDeclaredMethod("scheduleUpdate", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AccessTokenCache.class.getDeclaredMethod("update", OpaqueAccessToken.class, RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AccessTokenCache.class.getDeclaredMethod("requestUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AccessTokenCache.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AccessTokenCache.class.getDeclaredMethod("create", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

