/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;

public final class HandleStack {
    private int[] handles;
    private int top = 0;

    public HandleStack(int initialCapacity) {
        this(initialCapacity, false);
    }

    public HandleStack(int initialCapacity, boolean fill) {
        this.handles = new int[initialCapacity];
        if (fill) {
            this.pushRange(0, initialCapacity);
        }
    }

    public void push(int i) {
        if (this.top >= this.handles.length) {
            this.handles = Arrays.copyOf(this.handles, this.handles.length * 2);
        }
        this.handles[this.top++] = i;
    }

    @CompilerDirectives.TruffleBoundary
    public void pushRange(int start, int end) {
        int n = end - start;
        if (this.top + n > this.handles.length) {
            this.handles = Arrays.copyOf(this.handles, this.top + n);
        }
        for (int i = 0; i < n; ++i) {
            this.handles[this.top + i] = end - i - 1;
        }
        this.top += n;
    }

    public int pop() {
        if (this.top <= 0) {
            return -1;
        }
        return this.handles[--this.top];
    }

    public int getTop() {
        return this.top;
    }
}

