/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class RedshiftTime
extends Time {
    private static final long serialVersionUID = 3592492258676494276L;
    private Calendar calendar;
    private int nanos;
    public static ThreadLocal<SimpleDateFormat> TIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };

    public RedshiftTime(long time) {
        this(time, null);
    }

    public RedshiftTime(long time, int nanos) {
        this(time, null, nanos);
    }

    public RedshiftTime(long time, Calendar calendar) {
        this(time, calendar, 0);
    }

    public RedshiftTime(long time, Calendar calendar, int nanos) {
        super(time);
        this.setCalendar(calendar);
        this.nanos = nanos;
    }

    public RedshiftTime(Time time, int nanos) {
        this(time.getTime(), null, nanos);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RedshiftTime)) {
            return false;
        }
        RedshiftTime other = (RedshiftTime)obj;
        return !(this.calendar == null ? other.calendar != null : !this.calendar.equals(other.calendar));
    }

    @Override
    public Object clone() {
        RedshiftTime clone = (RedshiftTime)super.clone();
        if (this.getCalendar() != null) {
            clone.setCalendar((Calendar)this.getCalendar().clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder baseResult = new StringBuilder();
        baseResult.append(TIME_FORMAT.get().format(this.getTime()));
        if (0 < this.nanos) {
            while (999999 < this.nanos) {
                this.nanos /= 10;
            }
            baseResult.append(".");
            baseResult.append(String.valueOf(this.nanos));
        }
        return baseResult.toString();
    }
}

