/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.emoji.SvgNanoParser;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.FutureBufferedImage;
import net.sourceforge.plantuml.preproc.StdlibSprite;
import net.sourceforge.plantuml.preproc.spm.SpmChannel;
import net.sourceforge.plantuml.utils.Log;

public class Stdlib {
    private static final ConcurrentMap<String, Stdlib> all = new ConcurrentHashMap<String, Stdlib>();
    private final List<Integer> colors = new ArrayList<Integer>();
    private final Map<String, byte[]> puml = new HashMap<String, byte[]>();
    private final Map<String, byte[]> json = new HashMap<String, byte[]>();
    private final Map<String, StdlibSprite> sprites = new HashMap<String, StdlibSprite>();
    private final Map<String, SvgNanoParser> svgs = new HashMap<String, SvgNanoParser>();
    private final List<FutureBufferedImage> images = new ArrayList<FutureBufferedImage>();
    private final String name;
    private final Map<String, String> info = new HashMap<String, String>();

    private Stdlib(String name) throws IOException {
        this.name = name;
        try (InputStream is = this.getInternalInputStream(SpmChannel.INFO);){
            List<String> pathInfo = FileUtils.readStrings(is);
            for (String s : pathInfo) {
                String[] data;
                if (!s.contains("=") || (data = s.split("=")).length != 2) continue;
                this.info.put(data[0], data[1]);
            }
        }
    }

    public static byte[] getPumlResource(String fullname) {
        int last = (fullname = fullname.toLowerCase().replace(".puml", "")).indexOf(47);
        if (last == -1) {
            return null;
        }
        try {
            Stdlib folder = Stdlib.retrieve(fullname.substring(0, last));
            if (folder == null || folder.info.size() == 0) {
                return null;
            }
            return folder.loadPumlResource(fullname.substring(last + 1));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    public static byte[] getJsonResource(String fullname) {
        int last = fullname.indexOf(47);
        if (last == -1) {
            return null;
        }
        try {
            Stdlib folder = Stdlib.retrieve(fullname.substring(0, last));
            if (folder == null || folder.info.size() == 0) {
                return null;
            }
            return folder.loadJsonResource(fullname.substring(last + 1));
        }
        catch (IOException e) {
            Logme.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadPumlResource(String file) throws IOException {
        Map<String, byte[]> map = this.puml;
        synchronized (map) {
            this.initMapIfNeeded(this.puml, SpmChannel.PUML);
            return this.puml.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadJsonResource(String file) throws IOException {
        Map<String, byte[]> map = this.json;
        synchronized (map) {
            this.initMapIfNeeded(this.json, SpmChannel.JSON);
            return this.json.get(file);
        }
    }

    private void initMapIfNeeded(Map<String, byte[]> map, SpmChannel channel) throws IOException {
        if (map.size() == 0) {
            try (InputStream is = this.getInternalInputStream(channel);
                 DataInputStream dis = new DataInputStream(is);){
                int nb = dis.readInt();
                for (int i = 0; i < nb; ++i) {
                    String name = dis.readUTF();
                    int len = dis.readInt();
                    byte[] data = FileUtils.readExactly(dis, len);
                    map.put(name.toLowerCase(), data);
                }
            }
        }
    }

    public static Stdlib retrieve(String name) throws IOException {
        return all.computeIfAbsent(name, key -> {
            try {
                Stdlib result = new Stdlib((String)key);
                String link = result.getLinkFromInfo();
                if (link != null) {
                    return Stdlib.retrieve(link);
                }
                return result;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private String getLinkFromInfo() {
        return this.info.get("link");
    }

    private static int read1byte(InputStream is) throws IOException {
        return is.read() & 0xFF;
    }

    static int read2bytes(InputStream is) throws IOException {
        return (Stdlib.read1byte(is) << 8) + Stdlib.read1byte(is);
    }

    private InputStream getInternalInputStream(SpmChannel channel) throws IOException {
        return channel.getInternalInputStream(this.name);
    }

    public static Collection<String> getAllFolderNames() throws IOException {
        InputStream home = SpmChannel.inputStream("stdlib/home.spm");
        if (home == null) {
            throw new IOException("Cannot access to /stdlib files");
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(home));){
            TreeSet<String> treeSet = new TreeSet<String>(br.lines().collect(Collectors.toList()));
            return treeSet;
        }
    }

    private void extractMeFull() throws IOException {
    }

    public static void addInfoVersion(List<String> strings, boolean details) {
        try {
            for (String name : Stdlib.getAllFolderNames()) {
                Stdlib folder = Stdlib.retrieve(name);
                if (details) {
                    strings.add("<b>" + name);
                    strings.add("Version " + folder.getVersion());
                    strings.add("Delivered by " + folder.getSource());
                    strings.add(" ");
                    continue;
                }
                strings.add("* " + name + " (Version " + folder.getVersion() + ")");
            }
        }
        catch (IOException e) {
            Log.error("Error " + e);
            return;
        }
    }

    public String getVersion() {
        String result = this.info.get("VERSION");
        if (result == null) {
            result = this.info.get("version");
        }
        return result;
    }

    public String getSource() {
        String result = this.info.get("SOURCE");
        if (result == null) {
            result = this.info.get("source");
        }
        return result;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.info);
    }

    public static void printStdLib() {
        ArrayList<String> print = new ArrayList<String>();
        Stdlib.addInfoVersion(print, true);
        for (String s : print) {
            System.out.println(s.replace("<b>", ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sprite readSprite(String name) throws IOException {
        Map<String, StdlibSprite> map = this.sprites;
        synchronized (map) {
            if (this.sprites.size() == 0) {
                try (InputStream is = this.getInternalInputStream(SpmChannel.SPRITE);
                     DataInputStream dis = new DataInputStream(is);){
                    int nb = dis.readInt();
                    for (int i = 0; i < nb; ++i) {
                        String spriteName = dis.readUTF();
                        int width = dis.readInt();
                        int height = dis.readInt();
                        int nbLines = (height + 1) / 2;
                        byte[] data = FileUtils.readExactly(dis, width * nbLines);
                        StdlibSprite sprite = new StdlibSprite(width, height, data);
                        this.sprites.put(spriteName, sprite);
                    }
                }
            }
            return this.sprites.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sprite readSvgSprite(String name) throws IOException {
        Map<String, SvgNanoParser> map = this.svgs;
        synchronized (map) {
            if (this.svgs.size() == 0) {
                try (InputStream is = this.getInternalInputStream(SpmChannel.SVG);
                     DataInputStream dis = new DataInputStream(is);){
                    int nb = dis.readInt();
                    for (int i = 0; i < nb; ++i) {
                        String spriteName = dis.readUTF();
                        String svg = dis.readUTF();
                        this.svgs.put(spriteName, new SvgNanoParser(svg));
                    }
                }
            }
            return this.svgs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureBufferedImage readDataImagePng(int num) throws IOException {
        List<FutureBufferedImage> list = this.images;
        synchronized (list) {
            if (this.images.size() == 0) {
                try (InputStream is = this.getInternalInputStream(SpmChannel.IMAGE);
                     DataInputStream dis = new DataInputStream(is);){
                    int nb = dis.readInt();
                    this.readColorTable(dis);
                    for (int i = 0; i < nb; ++i) {
                        int width = dis.readInt();
                        int height = dis.readInt();
                        byte[] data = FileUtils.readExactly(dis, width * height * 2);
                        this.images.add(new FutureBufferedImage(this.colors, width, height, data));
                    }
                }
            }
            return this.images.get(num);
        }
    }

    private void readColorTable(InputStream is) throws IOException {
        int size = Stdlib.read2bytes(is);
        for (int i = 0; i < size; ++i) {
            int alpha = Stdlib.read1byte(is);
            int red = Stdlib.read1byte(is);
            int green = Stdlib.read1byte(is);
            int blue = Stdlib.read1byte(is);
            int rgb = (alpha << 24) + (red << 16) + (green << 8) + blue;
            this.colors.add(rgb);
        }
    }
}

