/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ImageProviderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageCriterion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageCriterion> {
    private static final SdkField<List<String>> IMAGE_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageProviders").getter(ImageCriterion.getter(ImageCriterion::imageProviders)).setter(ImageCriterion.setter(Builder::imageProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageProviderSet").unmarshallLocationName("imageProviderSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_PROVIDERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageCriterion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> imageProviders;

    private ImageCriterion(BuilderImpl builder) {
        this.imageProviders = builder.imageProviders;
    }

    public final boolean hasImageProviders() {
        return this.imageProviders != null && !(this.imageProviders instanceof SdkAutoConstructList);
    }

    public final List<String> imageProviders() {
        return this.imageProviders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageProviders() ? this.imageProviders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageCriterion)) {
            return false;
        }
        ImageCriterion other = (ImageCriterion)obj;
        return this.hasImageProviders() == other.hasImageProviders() && Objects.equals(this.imageProviders(), other.imageProviders());
    }

    public final String toString() {
        return ToString.builder((String)"ImageCriterion").add("ImageProviders", this.hasImageProviders() ? this.imageProviders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageProviders": {
                return Optional.ofNullable(clazz.cast(this.imageProviders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ImageProviderSet", IMAGE_PROVIDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageCriterion, T> g) {
        return obj -> g.apply((ImageCriterion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> imageProviders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageCriterion model) {
            this.imageProviders(model.imageProviders);
        }

        public final Collection<String> getImageProviders() {
            if (this.imageProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageProviders;
        }

        public final void setImageProviders(Collection<String> imageProviders) {
            this.imageProviders = ImageProviderListCopier.copy(imageProviders);
        }

        @Override
        public final Builder imageProviders(Collection<String> imageProviders) {
            this.imageProviders = ImageProviderListCopier.copy(imageProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageProviders(String ... imageProviders) {
            this.imageProviders(Arrays.asList(imageProviders));
            return this;
        }

        public ImageCriterion build() {
            return new ImageCriterion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageCriterion> {
        public Builder imageProviders(Collection<String> var1);

        public Builder imageProviders(String ... var1);
    }
}

