/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hibernate.Incubating;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.spi.Cleaner;

@Incubating
public class StandardTableCleaner
implements Cleaner {
    protected final Dialect dialect;

    public StandardTableCleaner(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getSqlBeforeString() {
        return this.dialect.getDisableConstraintsStatement();
    }

    @Override
    public String getSqlAfterString() {
        return this.dialect.getEnableConstraintsStatement();
    }

    @Override
    public String[] getSqlTruncateStrings(Collection<Table> tables, Metadata metadata, SqlStringGenerationContext context) {
        String[] tableNames = tables.stream().map(table -> context.format(StandardTableCleaner.getTableName(table))).collect(Collectors.toList()).toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        String[] truncateTableStatements = this.dialect.getTruncateTableStatements(tableNames);
        String[] initStatements = tables.stream().flatMap(table -> table.getInitCommands(context).stream()).flatMap(command -> Arrays.stream(command.initCommands())).toList().toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        return ArrayHelper.join(truncateTableStatements, initStatements);
    }

    @Override
    public String getSqlDisableConstraintString(ForeignKey foreignKey, Metadata metadata, SqlStringGenerationContext context) {
        return this.dialect.getDisableConstraintStatement(context.format(StandardTableCleaner.getTableName(foreignKey.getTable())), foreignKey.getName());
    }

    @Override
    public String getSqlEnableConstraintString(ForeignKey foreignKey, Metadata metadata, SqlStringGenerationContext context) {
        return this.dialect.getEnableConstraintStatement(context.format(StandardTableCleaner.getTableName(foreignKey.getTable())), foreignKey.getName());
    }

    private static QualifiedNameParser.NameParts getTableName(Table table) {
        return new QualifiedNameParser.NameParts(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier());
    }
}

