/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.RaftManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.TimingWheelExpirationService;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%s!B\u001f?\u0011\u0003\u0019e!B#?\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0013\u0001\u0006\"\u00025\u0002\t\u0013I\u0007\"B=\u0002\t\u0013Qh!B#?\u0001\u0005-\u0001\"CA\u001c\r\t\u0005\t\u0015!\u0003^\u0011%yhA!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002:\u0019\u0011\t\u0011)A\u0005\u0003wA!\"a\u0012\u0007\u0005\u0003\u0005\u000b\u0011BA%\u0011)\t9F\u0002B\u0001B\u0003%\u0011\u0011\f\u0005\u000b\u0003?2!\u0011!Q\u0001\n\u0005m\u0002BCA1\r\t\u0005\t\u0015!\u0003\u0002d!Q\u0011Q\u000e\u0004\u0003\u0002\u0003\u0006I!a\u001c\t\u0015\u0005edA!A!\u0002\u0013\tY\b\u0003\u0006\u0002\u0006\u001a\u0011\t\u0011)A\u0005\u0003\u000fC!\"!$\u0007\u0005\u000b\u0007I\u0011AAH\u0011)\tyL\u0002B\u0001B\u0003%\u0011\u0011\u0013\u0005\u000b\u0003\u00034!\u0011!Q\u0001\n\u0005\r\u0007BCAe\r\t\u0005\t\u0015!\u0003\u0002L\"Q\u0011\u0011\u001b\u0004\u0003\u0002\u0003\u0006I!a5\t\r53A\u0011AAp\u0011%\tyP\u0002b\u0001\n\u0003\u0011\t\u0001\u0003\u0005\u0003\u0010\u0019\u0001\u000b\u0011\u0002B\u0002\u0011%\u0011\tB\u0002b\u0001\n\u0013\u0011\u0019\u0002\u0003\u0005\u0003\u001c\u0019\u0001\u000b\u0011\u0002B\u000b\u0011%\u0011iB\u0002b\u0001\n\u0013\u0011y\u0002C\u0004\u0003\"\u0019\u0001\u000b\u0011B/\t\u0013\t\rbA1A\u0005\n\t\u0015\u0002\u0002\u0003B\u0017\r\u0001\u0006IAa\n\t\u0013\t=bA1A\u0005\n\tE\u0002\u0002\u0003B\u001d\r\u0001\u0006IAa\r\t\u0011a4!\u0019!C\u0005\u0005wAqA!\u0010\u0007A\u0003%\u0011\u000bC\u0005\u0003@\u0019\u0011\r\u0011\"\u0003\u0003B!A!Q\t\u0004!\u0002\u0013\u0011\u0019\u0005C\u0005\u0003H\u0019\u0011\r\u0011\"\u0011\u0003J!A!\u0011\u000b\u0004!\u0002\u0013\u0011Y\u0005C\u0005\u0003T\u0019\u0011\r\u0011\"\u0003\u0003V!A!Q\f\u0004!\u0002\u0013\u00119\u0006C\u0005\u0003`\u0019\u0011\r\u0011\"\u0003\u0003b!A!q\u000e\u0004!\u0002\u0013\u0011\u0019\u0007C\u0005\u0003r\u0019\u0011\r\u0011\"\u0003\u0003t!A!1\u0010\u0004!\u0002\u0013\u0011)\bC\u0005\u0003~\u0019\u0011\r\u0011\"\u0011\u0003\u0000!A!q\u0011\u0004!\u0002\u0013\u0011\t\tC\u0005\u0003\n\u001a\u0011\r\u0011\"\u0003\u0003\f\"A!1\u0013\u0004!\u0002\u0013\u0011i\tC\u0004\u0003\u0016\u001a!\tAa&\t\u000f\t}e\u0001\"\u0001\u0003\u0018\"9!\u0011\u0015\u0004\u0005B\t\r\u0006b\u0002B\\\r\u0011\u0005#\u0011\u0018\u0005\b\u0005c4A\u0011\u0002Bz\u0011\u001d\u0011)P\u0002C\u0005\u0005oDqA!?\u0007\t\u0013\u0011Y\u0010C\u0004\u0003~\u001a!IAa@\t\u000f\r\u001da\u0001\"\u0003\u0004\n!911\u0005\u0004\u0005B\r\u0015\u0002bBB\u0017\r\u0011\u00053q\u0006\u0005\b\u0007\u000b2A\u0011IB$\u0003AY\u0015MZ6b%\u00064G/T1oC\u001e,'O\u0003\u0002@\u0001\u0006!!/\u00194u\u0015\u0005\t\u0015!B6bM.\f7\u0001\u0001\t\u0003\t\u0006i\u0011A\u0010\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u001c\"!A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1)\u0001\nde\u0016\fG/\u001a'pO\u0012K'/Z2u_JLHcA)Z7B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0003S>T\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y'\n!a)\u001b7f\u0011\u0015Q6\u00011\u0001R\u0003\u0019awn\u001a#je\")Al\u0001a\u0001;\u0006QAn\\4ESJt\u0015-\\3\u0011\u0005y+gBA0d!\t\u0001\u0017*D\u0001b\u0015\t\u0011')\u0001\u0004=e>|GOP\u0005\u0003I&\u000ba\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A-S\u0001\fY>\u001c7\u000eR1uC\u0012K'\u000f\u0006\u0002koB\u00111.^\u0007\u0002Y*\u0011QN\\\u0001\u0005kRLGN\u0003\u0002pa\u000611/\u001a:wKJT!!Q9\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m2\u0014\u0001BR5mK2{7m\u001b\u0005\u0006q\u0012\u0001\r!U\u0001\bI\u0006$\u0018\rR5s\u0003IA\u0017m\u001d#jM\u001a,'/\u001a8u\u0019><G)\u001b:\u0015\u0005mt\bC\u0001%}\u0013\ti\u0018JA\u0004C_>dW-\u00198\t\r},\u0001\u0019AA\u0001\u0003\u0019\u0019wN\u001c4jOB!\u00111AA\u0004\u001b\t\t)A\u0003\u0002p\u0001&!\u0011\u0011BA\u0003\u0005-Y\u0015MZ6b\u0007>tg-[4\u0016\t\u00055\u0011\u0011D\n\u0007\r\u001d\u000by!a\u000b\u0011\u000b\u0011\u000b\t\"!\u0006\n\u0007\u0005MaHA\u0006SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA\f\u00033a\u0001\u0001B\u0004\u0002\u001c\u0019\u0011\r!!\b\u0003\u0003Q\u000bB!a\b\u0002&A\u0019\u0001*!\t\n\u0007\u0005\r\u0012JA\u0004O_RD\u0017N\\4\u0011\u0007!\u000b9#C\u0002\u0002*%\u00131!\u00118z!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\u0001\u0006)Q\u000f^5mg&!\u0011QGA\u0018\u0005\u001daunZ4j]\u001e\f\u0011b\u00197vgR,'/\u00133\u0002%5,G/\u00193bi\u0006dun\u001a#jeV+\u0018\u000e\u001a\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t9\u0002\r\r|W.\\8o\u0013\u0011\t)%a\u0010\u0003\tU+\u0018\u000eZ\u0001\u0006g\u0016\u0014H-\u001a\t\u0007\u0003\u0017\n\u0019&!\u0006\u000e\u0005\u00055#\u0002BA(\u0003#\nQb]3sS\u0006d\u0017N_1uS>t'bAA!]&!\u0011QKA'\u0005-\u0011VmY8sIN+'\u000fZ3\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011QHA.\u0013\u0011\ti&a\u0010\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069Ao\u001c9jG&#\u0017\u0001\u0002;j[\u0016\u0004B!!\u001a\u0002j5\u0011\u0011q\r\u0006\u0005\u0003c\ty$\u0003\u0003\u0002l\u0005\u001d$\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002r\u0005UTBAA:\u0015\u0011\ti'a\u0010\n\t\u0005]\u00141\u000f\u0002\b\u001b\u0016$(/[2t\u0003Q)\u0007\u0010^3s]\u0006d7JU1gi6+GO]5dgB!\u0011QPAA\u001b\t\tyH\u0003\u0002@a&!\u00111QA@\u0005Q)\u0005\u0010^3s]\u0006d7JU1gi6+GO]5dg\u0006\u0019B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_(qiB!\u0001*!#^\u0013\r\tY)\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u00029\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sKV\u0011\u0011\u0011\u0013\t\u0007\u0003'\u000bY*a(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b!bY8oGV\u0014(/\u001a8u\u0015\tiW+\u0003\u0003\u0002\u001e\u0006U%!E\"p[BdW\r^1cY\u00164U\u000f^;sKBA\u0011\u0011UAR\u0003O\u000b\u0019,\u0004\u0002\u0002\u001a&!\u0011QUAM\u0005\ri\u0015\r\u001d\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011QV+\u0002\t1\fgnZ\u0005\u0005\u0003c\u000bYKA\u0004J]R,w-\u001a:\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/V\u0003\rqW\r^\u0005\u0005\u0003{\u000b9LA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\fQdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X\rI\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN\u0004b!!)\u0002F\u0006M\u0016\u0002BAd\u00033\u0013!bQ8mY\u0016\u001cG/[8o\u00039awnY1m\u0019&\u001cH/\u001a8feN\u0004B!! \u0002N&!\u0011qZA@\u0005%)e\u000e\u001a9pS:$8/A\tgCR\fGNR1vYRD\u0015M\u001c3mKJ\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0004\u00033t\u0017!\u00024bk2$\u0018\u0002BAo\u0003/\u0014ABR1vYRD\u0015M\u001c3mKJ$b$!9\u0002d\u0006\u0015\u0018q]Au\u0003W\fi/a<\u0002r\u0006M\u0018Q_A|\u0003s\fY0!@\u0011\t\u00113\u0011Q\u0003\u0005\u0007\u0003o1\u0002\u0019A/\t\r}4\u0002\u0019AA\u0001\u0011\u001d\tID\u0006a\u0001\u0003wAq!a\u0012\u0017\u0001\u0004\tI\u0005C\u0004\u0002XY\u0001\r!!\u0017\t\u000f\u0005}c\u00031\u0001\u0002<!9\u0011\u0011\r\fA\u0002\u0005\r\u0004bBA7-\u0001\u0007\u0011q\u000e\u0005\b\u0003s2\u0002\u0019AA>\u0011\u001d\t)I\u0006a\u0001\u0003\u000fCq!!$\u0017\u0001\u0004\t\t\nC\u0004\u0002BZ\u0001\r!a1\t\u000f\u0005%g\u00031\u0001\u0002L\"9\u0011\u0011\u001b\fA\u0002\u0005M\u0017aC1qSZ+'o]5p]N,\"Aa\u0001\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQ1A!\u0003q\u0003\u001d\u0019G.[3oiNLAA!\u0004\u0003\b\tY\u0011\t]5WKJ\u001c\u0018n\u001c8t\u00031\t\u0007/\u001b,feNLwN\\:!\u0003)\u0011\u0018M\u001a;D_:4\u0017nZ\u000b\u0003\u0005+\u0001B!! \u0003\u0018%!!\u0011DA@\u00051\tVo\u001c:v[\u000e{gNZ5h\u0003-\u0011\u0018M\u001a;D_:4\u0017n\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DX#A/\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"Aa\n\u0011\t\u0005\u0015$\u0011F\u0005\u0005\u0005W\t9G\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0005g\u00012a\u001bB\u001b\u0013\r\u00119\u0004\u001c\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u000b\u0002#\u0006AA-\u0019;b\t&\u0014\b%A\u0006eCR\fG)\u001b:M_\u000e\\WC\u0001B\"!\u0011A\u0015\u0011\u00126\u0002\u0019\u0011\fG/\u0019#je2{7m\u001b\u0011\u0002\u001bI,\u0007\u000f\\5dCR,G\rT8h+\t\u0011Y\u0005\u0005\u0003\u0002~\t5\u0013\u0002\u0002B(\u0003\u007f\u0012QBU3qY&\u001c\u0017\r^3e\u0019><\u0017A\u0004:fa2L7-\u0019;fI2{w\rI\u0001\u000b]\u0016$8\t[1o]\u0016dWC\u0001B,!\u0011\tiH!\u0017\n\t\tm\u0013q\u0010\u0002\u0014\u0017\u000647.\u0019(fi^|'o[\"iC:tW\r\\\u0001\f]\u0016$8\t[1o]\u0016d\u0007%A\bfqBL'/\u0019;j_:$\u0016.\\3s+\t\u0011\u0019\u0007\u0005\u0003\u0003f\t-TB\u0001B4\u0015\r\u0011I\u0007\\\u0001\u0006i&lWM]\u0005\u0005\u0005[\u00129GA\u0006TsN$X-\u001c+j[\u0016\u0014\u0018\u0001E3ya&\u0014\u0018\r^5p]RKW.\u001a:!\u0003E)\u0007\u0010]5sCRLwN\\*feZL7-Z\u000b\u0003\u0005k\u0002B!! \u0003x%!!\u0011PA@\u0005q!\u0016.\\5oO^CW-\u001a7FqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016\f!#\u001a=qSJ\fG/[8o'\u0016\u0014h/[2fA\u000511\r\\5f]R,\"A!!\u0011\r\u0005u$1QA\u000b\u0013\u0011\u0011))a \u0003\u001f-\u000bgm[1SC\u001a$8\t\\5f]R\fqa\u00197jK:$\b%\u0001\u0007dY&,g\u000e\u001e#sSZ,'/\u0006\u0002\u0003\u000eB1\u0011Q\u0010BH\u0003+IAA!%\u0002\u0000\t)2*\u00194lCJ\u000bg\r^\"mS\u0016tG\u000f\u0012:jm\u0016\u0014\u0018!D2mS\u0016tG\u000f\u0012:jm\u0016\u0014\b%A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\te\u0005c\u0001%\u0003\u001c&\u0019!QT%\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u0006A!/Z4jgR,'\u000f\u0006\u0003\u0003\u001a\n\u0015\u0006b\u0002BTg\u0001\u0007!\u0011V\u0001\tY&\u001cH/\u001a8feB1!1\u0016BY\u0003+qA!! \u0003.&!!qVA@\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0005\u0005g\u0013)L\u0001\u0005MSN$XM\\3s\u0015\u0011\u0011y+a \u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u))\u0011YL!3\u0003Z\n\r(q\u001d\t\u0007\u0003'\u000bYJ!0\u0011\t\t}&QY\u0007\u0003\u0005\u0003TAAa1\u0002@\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0003H\n\u0005'AC!qS6+7o]1hK\"9!1\u001a\u001bA\u0002\t5\u0017aB2p]R,\u0007\u0010\u001e\t\u0005\u0005\u001f\u0014).\u0004\u0002\u0003R*!!1[A \u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002Bl\u0005#\u0014aBU3rk\u0016\u001cHoQ8oi\u0016DH\u000fC\u0004\u0003\\R\u0002\rA!8\u0002\r!,\u0017\rZ3s!\u0011\u0011yMa8\n\t\t\u0005(\u0011\u001b\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000f\t\u0015H\u00071\u0001\u0003>\u00069!/Z9vKN$\bb\u0002Bui\u0001\u0007!1^\u0001\u000eGJ,\u0017\r^3e)&lW-T:\u0011\u0007!\u0013i/C\u0002\u0003p&\u0013A\u0001T8oO\u0006y!-^5mIJ\u000bg\r^\"mS\u0016tG\u000f\u0006\u0002\u0003\u0002\u0006\u0019\"-^5mI:+Go^8sW\u000eC\u0017M\u001c8fYR\u0011!qK\u0001\u000eGJ,\u0017\r^3ECR\fG)\u001b:\u0015\u0003E\u000b\u0001CY;jY\u0012lU\r^1eCR\fGj\\4\u0015\u0005\r\u0005\u0001c\u0001#\u0004\u0004%\u00191Q\u0001 \u0003!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0017A\u00052vS2$g*\u001a;x_J\\7\t\\5f]R$\"aa\u0003\u0011\u000f!\u001bia!\u0005\u0004\u001e%\u00191qB%\u0003\rQ+\b\u000f\\33!\u0011\u0019\u0019b!\u0007\u000e\u0005\rU!\u0002BB\f\u0003\u007f\tqA\\3uo>\u00148.\u0003\u0003\u0004\u001c\rU!\u0001\u0004'jgR,g.\u001a:OC6,\u0007\u0003\u0002B\u0003\u0007?IAa!\t\u0003\b\tia*\u001a;x_J\\7\t\\5f]R\fa\u0002\\3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007.\u0006\u0002\u0004(A!\u0011QPB\u0015\u0013\u0011\u0019Y#a \u0003\u001d1+\u0017\rZ3s\u0003:$W\t]8dQ\u0006Iao\u001c;fe:{G-\u001a\u000b\u0007\u0007c\u0019Ida\u0011\u0011\u000b!\u000bIia\r\u0011\t\u0005u2QG\u0005\u0005\u0007o\tyD\u0001\u0003O_\u0012,\u0007bBB\u001ew\u0001\u00071QH\u0001\u0003S\u0012\u00042\u0001SB \u0013\r\u0019\t%\u0013\u0002\u0004\u0013:$\bb\u0002BTw\u0001\u00071\u0011C\u0001\fe\u0016\u001cwN\u001d3TKJ$W-\u0006\u0002\u0002J\u0001")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> serde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final ExternalKRaftMetrics externalKRaftMetrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics, this.externalKRaftMetrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
        Utils.closeQuietly((AutoCloseable)this.expirationTimer(), (String)"expiration timer");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.clientDriver().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
        Utils.closeQuietly((AutoCloseable)this.netChannel(), (String)"net channel");
        Utils.closeQuietly((AutoCloseable)this.replicatedLog(), (String)"replicated log");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$2 -> {
            x$2.destroy();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private KafkaRaftClient<T> buildRaftClient() {
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde(), (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.config.processRoles().contains((Object)ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Feature.KRAFT_VERSION.supportedVersionRange(), this.raftConfig());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        return new KafkaNetworkChannel(this.time, (ListenerName)var2_2, (KafkaClient)var3_3, this.config.quorumConfig().requestTimeoutMs(), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog.logDirName((TopicPartition)logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), new MetadataLogConfig((AbstractConfig)this.config), this.config.nodeId());
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().get(0));
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)Option$.MODULE$.apply(this.config.effectiveListenerSecurityProtocolMap().get(controllerListenerName)).getOrElse((Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = "raft-client-" + this.config.nodeId();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), this.config.quorumConfig().requestTimeoutMs(), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    @Override
    public RecordSerde<T> recordSerde() {
        return this.serde;
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> serde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, ExternalKRaftMetrics externalKRaftMetrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.serde = serde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.externalKRaftMetrics = externalKRaftMetrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext("[RaftManager id=" + config.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, this.threadNamePrefix() + "-scheduler");
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
    }
}

