/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import org.jsampler.CC;
import org.jsampler.DOMUtils;
import org.jsampler.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Server
extends Resource {
    private String address = "127.0.0.1";
    private int port = 8888;

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
        this.fireChangeEvent();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
        this.fireChangeEvent();
    }

    public boolean isLocal() {
        if (this.getAddress() == null) {
            return false;
        }
        if ("127.0.0.1".equals(this.getAddress())) {
            return true;
        }
        return "localhost".equalsIgnoreCase(this.getAddress());
    }

    public void readObject(Node node) {
        if (node.getNodeType() != 1 || !node.getNodeName().equals("server")) {
            throw new IllegalArgumentException("Not a server node!");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            throw new IllegalArgumentException("The server name is undefined!");
        }
        DOMUtils.validateTextContent(node2);
        this.setName(node2.getFirstChild().getNodeValue());
        String string = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            string = node.getNodeName();
            if (string.equals("description")) {
                if (!node.hasChildNodes()) continue;
                DOMUtils.validateTextContent(node);
                this.setDescription(node.getFirstChild().getNodeValue());
                continue;
            }
            if (string.equals("address")) {
                if (!node.hasChildNodes()) continue;
                DOMUtils.validateTextContent(node);
                this.setAddress(node.getFirstChild().getNodeValue());
                continue;
            }
            if (string.equals("port")) {
                int n;
                if (!node.hasChildNodes()) continue;
                DOMUtils.validateTextContent(node);
                String string2 = node.getFirstChild().getNodeValue();
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Invalid port!");
                }
                this.setPort(n);
                continue;
            }
            CC.getLogger().info("Unknown field: " + string);
        }
    }

    public void writeObject(Document document, Node node) {
        Element element = document.createElement("server");
        element.setAttribute("name", this.getName());
        node.appendChild(element);
        node = element;
        element = document.createElement("description");
        element.appendChild(document.createTextNode(this.getDescription()));
        node.appendChild(element);
        element = document.createElement("address");
        element.appendChild(document.createTextNode(this.getAddress()));
        node.appendChild(element);
        element = document.createElement("port");
        element.appendChild(document.createTextNode(String.valueOf(this.getPort())));
        node.appendChild(element);
    }

    public String toString() {
        return this.getName();
    }
}

