/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertUnsafeCastCallToUnsafeCastIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ConvertUnsafeCastCallToUnsafeCastIntention
extends SelfTargetingIntention<KtDotQualifiedExpression> {
    public ConvertUnsafeCastCallToUnsafeCastIntention() {
        super(KtDotQualifiedExpression.class, KotlinBundle.lazyMessage((String)"convert.to.unsafe.cast", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtDotQualifiedExpression element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!JsPlatformKt.isJs((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)element))) {
            return false;
        }
        KtExpression ktExpression = element.getSelectorExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (!Intrinsics.areEqual((Object)(ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null), (Object)"unsafeCast")) {
            return false;
        }
        Object object = ResolutionUtils.resolveToCall$default((KtElement)element, null, 1, null);
        if (object == null || (object = object.getResultingDescriptor()) == null || (object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
            return false;
        }
        Object fqName2 = object;
        if (!Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.js.unsafeCast")) {
            return false;
        }
        Object object2 = UtilsKt.getCallExpression((KtQualifiedExpression)element);
        if (object2 == null || (object2 = object2.getTypeArguments()) == null || (object2 = (KtTypeProjection)CollectionsKt.singleOrNull((List)object2)) == null) {
            return false;
        }
        Object type2 = object2;
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)element.getReceiverExpression().getText(), (String)"getText(...)");
        Intrinsics.checkNotNullExpressionValue((Object)type2.getText(), (String)"getText(...)");
        this.setTextGetter((Function0<String>)KotlinBundle.lazyMessage((String)"convert.to.0.as.1", (Object[])objectArray));
        return true;
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = UtilsKt.getCallExpression((KtQualifiedExpression)element);
        if (object == null || (object = object.getTypeArguments()) == null || (object = (KtTypeProjection)CollectionsKt.singleOrNull((List)object)) == null) {
            return;
        }
        Object type2 = object;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        Object[] objectArray = new Object[2];
        objectArray[0] = element.getReceiverExpression();
        Intrinsics.checkNotNullExpressionValue((Object)type2.getText(), (String)"getText(...)");
        KtExpression newExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 as $1", (Object[])objectArray, (boolean)false, (int)4, null);
        element.replace((PsiElement)newExpression);
    }
}

