/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.run;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenSimpleConsoleEventsBuffer;
import org.jetbrains.idea.maven.utils.MavenLog;

public class ProcessListenerWithFilteredSpyOutput
implements ProcessListener {
    private static final Pattern CMD_END_PATTERN = Pattern.compile("\\((.)\\s*/\\s*[^)]\\)\\?");
    private final ProcessListener myListener;
    private final boolean myIsWindowsCmd;
    private final MavenSimpleConsoleEventsBuffer mySimpleConsoleEventsBuffer;
    private final ProcessHandler myProcessHandler;
    private final AtomicBoolean myTerminateEventReceived = new AtomicBoolean(false);

    ProcessListenerWithFilteredSpyOutput(ProcessListener listener2, ProcessHandler processHandler, boolean withLoggingOutputStream, boolean isWindowsCmd) {
        this.myListener = listener2;
        this.myProcessHandler = processHandler;
        this.myIsWindowsCmd = isWindowsCmd;
        this.mySimpleConsoleEventsBuffer = new MavenSimpleConsoleEventsBuffer.Builder((l, k) -> this.myListener.onTextAvailable(new ProcessEvent(processHandler, l), k)).withSpyOutput(Registry.is((String)"maven.spy.events.debug")).withLoggingOutputStream(withLoggingOutputStream).withHidingCmdExitQuestion(isWindowsCmd).build();
    }

    public void startNotified(@NotNull ProcessEvent event) {
        if (event == null) {
            ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(0);
        }
        this.myListener.startNotified(event);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(1);
        }
        this.myListener.processTerminated(event);
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        if (event == null) {
            ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(2);
        }
        this.myTerminateEventReceived.set(true);
        this.myListener.processWillTerminate(event, willBeDestroyed);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(4);
        }
        if (this.myTerminateEventReceived.get() && this.myIsWindowsCmd && this.tryToExtractYesButton(event.getText()) && !Registry.is((String)"maven.spy.events.debug")) {
            return;
        }
        this.mySimpleConsoleEventsBuffer.addText(event.getText(), (Key<Object>)outputType);
    }

    private boolean tryToExtractYesButton(@NlsSafe String text) {
        Matcher m = CMD_END_PATTERN.matcher(text);
        if (!m.find()) {
            return false;
        }
        String yesKey = m.group(1);
        MavenLog.LOG.debug("Exit message from bat script: " + text + "  extracted yesCode: " + yesKey);
        this.sayYes(yesKey);
        return true;
    }

    private void sayYes(String yes) {
        try {
            OutputStream input = this.myProcessHandler.getProcessInput();
            if (input == null) {
                MavenLog.LOG.warn("Cannot say yes to exit because process unput is null");
                return;
            }
            input.write((yes + "\r\n").getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            MavenLog.LOG.warn("exception while saying yes to exit:", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/execution/run/ProcessListenerWithFilteredSpyOutput";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startNotified";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processWillTerminate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

