/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineASTTransformationPerformer;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineASTTransformationPerformerEx;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineTransformationUtilKt;

@FunctionalInterface
public interface GroovyBlockProducer {
    public static final GroovyBlockProducer DEFAULT = (node, indent, wrap, context) -> {
        GroovyInlineASTTransformationPerformer performer;
        PsiElement psi = node.getPsi();
        if (!(psi instanceof GroovyPsiElement)) {
            return new GroovyBlock(node, indent, wrap, context);
        }
        if (!DumbService.isDumb((Project)node.getPsi().getProject()) && (performer = GroovyInlineTransformationUtilKt.getRootInlineTransformationPerformer((GroovyPsiElement)psi)) instanceof GroovyInlineASTTransformationPerformerEx) {
            return ((GroovyInlineASTTransformationPerformerEx)performer).computeFormattingBlock(node, context);
        }
        return new GroovyBlock(node, indent, wrap, context);
    };

    public Block generateBlock(@NotNull ASTNode var1, @NotNull Indent var2, @Nullable Wrap var3, @NotNull FormattingContext var4);
}

