/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.configuration;

import javax.inject.Inject;
import org.gradle.api.configuration.BuildFeature;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.configuration.DefaultBuildFeature;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.internal.buildoption.Option;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.lazy.Lazy;

public class DefaultBuildFeatures
implements BuildFeatures {
    private final Lazy<BuildFeature> configurationCache = Lazy.atomic().of(() -> DefaultBuildFeatures.createConfigurationCache(startParameter, buildModelParameters));
    private final Lazy<BuildFeature> isolatedProjects = Lazy.atomic().of(() -> DefaultBuildFeatures.createIsolatedProjects(startParameter, buildModelParameters));

    @Inject
    public DefaultBuildFeatures(StartParameterInternal startParameter, BuildModelParameters buildModelParameters) {
    }

    public BuildFeature getConfigurationCache() {
        return (BuildFeature)this.configurationCache.get();
    }

    public BuildFeature getIsolatedProjects() {
        return (BuildFeature)this.isolatedProjects.get();
    }

    private static BuildFeature createConfigurationCache(StartParameterInternal startParameter, BuildModelParameters buildModelParameters) {
        ProviderInternal<Boolean> isRequested = DefaultBuildFeatures.getRequestedProvider(startParameter.getConfigurationCache());
        ProviderInternal isActive = Providers.of((Object)buildModelParameters.isConfigurationCache());
        return new DefaultBuildFeature((Provider<Boolean>)isRequested, (Provider<Boolean>)isActive);
    }

    private static BuildFeature createIsolatedProjects(StartParameterInternal startParameter, BuildModelParameters buildModelParameters) {
        ProviderInternal<Boolean> isRequested = DefaultBuildFeatures.getRequestedProvider(startParameter.getIsolatedProjects());
        ProviderInternal isActive = Providers.of((Object)buildModelParameters.isIsolatedProjects());
        return new DefaultBuildFeature((Provider<Boolean>)isRequested, (Provider<Boolean>)isActive);
    }

    private static ProviderInternal<Boolean> getRequestedProvider(Option.Value<Boolean> optionValue) {
        return Providers.ofNullable(optionValue.isExplicit() ? (Boolean)optionValue.get() : null);
    }
}

