/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.transform;

import java.util.ArrayList;
import java.util.List;
import org.gradle.model.dsl.internal.transform.InputReference;

public class InputReferences {
    private final List<InputReference> ownReferences = new ArrayList<InputReference>();
    private final List<InputReference> nestedReferences = new ArrayList<InputReference>();

    public List<InputReference> getOwnReferences() {
        return this.ownReferences;
    }

    public void ownReference(String path, int lineNumber) {
        this.ownReferences.add(new InputReference(path, lineNumber));
    }

    public boolean isEmpty() {
        return this.ownReferences.isEmpty() && this.nestedReferences.isEmpty();
    }

    public List<InputReference> getNestedReferences() {
        return this.nestedReferences;
    }

    public void addNestedReferences(InputReferences inputReferences) {
        this.nestedReferences.addAll(inputReferences.getOwnReferences());
        this.nestedReferences.addAll(inputReferences.getNestedReferences());
    }

    public void nestedReference(String path, int lineNumber) {
        this.nestedReferences.add(new InputReference(path, lineNumber));
    }

    public List<InputReference> getAllReferences() {
        ArrayList<InputReference> result = new ArrayList<InputReference>(this.ownReferences.size() + this.nestedReferences.size());
        result.addAll(this.ownReferences);
        result.addAll(this.nestedReferences);
        return result;
    }
}

