---
stage: Application Security Testing
group: Secret Detection
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: シークレット検出
description: 検出、防止、モニタリング、ストレージ、失効、レポート作成
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

アプリケーションは、CI/CDサービス、データベース、外部ストレージなどの外部リソースを使用する場合があります。これらのリソースへのアクセスには認証が必要で、通常は秘密キーやトークンなどの静的な方法を使用します。これらの方法は、他の人と共有することを意図していないため、「シークレット」と呼ばれます。

シークレットが漏洩するリスクを最小限に抑えるために、常に[リポジトリの外部にシークレットを保存](../../../ci/secrets/_index.md)してください。ただし、シークレットが誤ってGitリポジトリにコミットされることがあります。機密性の高い値がリモートリポジトリにプッシュされると、リポジトリへのアクセス権を持つ人は誰でも、そのシークレットを使用して承認されたユーザーになりすませるようになってしまいます。

シークレット検出は、アクティビティーをモニタリングして、次の両方を行います。

- シークレットの漏洩を防止できるようにする。
- シークレットが漏洩した場合に対応できるようにする。

多層的なセキュリティアプローチを採用し、利用可能なすべてのシークレット検出方法を有効にする必要があります。

- [シークレットプッシュ保護](secret_push_protection/_index.md)は、変更をGitLabにプッシュするときに、コミットをスキャンしてシークレットを探します。シークレットが検出された場合、シークレットプッシュ保護をスキップしない限り、プッシュはブロックされます。この方法により、シークレットが漏洩するリスクが軽減されます。
- [パイプラインシークレット検出](pipeline/_index.md)は、プロジェクトのCI/CDパイプラインの一部として実行されます。リポジトリのデフォルトブランチへのコミットは、シークレットがないかスキャンされます。マージリクエストパイプラインでパイプラインシークレット検出が有効になっている場合、開発ブランチへのコミットはシークレットがないかスキャンされるため、デフォルトブランチにコミットされる前に対応できます。
- [クライアント側のシークレット検出](client/_index.md)は、イシューとマージリクエストの両方で、GitLabに保存される前に、説明とコメントをスキャンしてシークレットを探します。シークレットが検出された場合は、インプットを編集してシークレットを削除するか、誤検出の場合は説明またはコメントを保存できます。

シークレットがリポジトリにコミットされると、GitLabは脆弱性レポートにその漏洩を記録します。一部のシークレットタイプでは、GitLabは漏洩したシークレットを自動的に失効させることもできます。漏洩したシークレットは、できるだけ早く失効させて交換する必要があります。シークレット固有の修正ガイダンスについては、脆弱性レポートに記載されている詳細を確認してください。

## 関連トピック {#related-topics}

- [シークレット検出の除外](exclusions.md)
- [脆弱性レポート](../vulnerability_report/_index.md)
- [流出したシークレットへの自動応答](automatic_response.md)
- [プッシュルール](../../project/repository/push_rules.md)
