/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.lock;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class AltibaseLock
implements DBAServerLock {
    private int waitSid;
    private int waitPid;
    private int waitTxid;
    private String waitUser;
    private String waitQuery;
    private String objSchema;
    private String objName;
    private int holdSid;
    private int holdPid;
    private int holdTxid;
    private String holdUser;
    private String holdQuery;
    private DBAServerLock hold = null;
    private List<DBAServerLock> waiters = new ArrayList<DBAServerLock>(0);
    private AltibaseDataSource dataSource;

    public AltibaseLock(ResultSet dbResult, AltibaseDataSource dataSource) {
        this.waitSid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"w_sid");
        this.waitPid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"w_pid");
        this.waitTxid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"w_txid");
        this.waitUser = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"w_user_name");
        this.waitQuery = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"w_query");
        this.objName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"w_obj_schema");
        this.objSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"w_obj_name");
        this.holdSid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"h_sid");
        this.holdPid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"h_pid");
        this.holdTxid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"h_txid");
        this.holdUser = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"h_user_name");
        this.holdQuery = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"h_query");
        this.dataSource = dataSource;
    }

    public String getTitle() {
        return String.valueOf(this.waitSid);
    }

    public DBAServerLock getHoldBy() {
        return this.hold;
    }

    public DBAServerLock getHold() {
        return this.hold;
    }

    public Integer getId() {
        return this.waitSid;
    }

    public List<DBAServerLock> waitThis() {
        return this.waiters;
    }

    public Integer getHoldID() {
        return this.holdSid;
    }

    public void setHoldBy(DBAServerLock lock) {
        this.hold = lock;
    }

    @Property(viewable=true, order=1)
    public int getWait_sid() {
        return this.waitSid;
    }

    @Property(viewable=true, order=2)
    public int getWait_pid() {
        return this.waitPid;
    }

    @Property(viewable=true, order=3)
    public int getWait_txid() {
        return this.waitTxid;
    }

    @Property(viewable=true, order=4)
    public String getWait_user() {
        return this.waitUser;
    }

    @Property(viewable=true, order=5)
    public String getWait_query() {
        return this.waitQuery;
    }

    @Property(viewable=true, order=6)
    public String getOwner() {
        return this.objSchema;
    }

    @Property(viewable=true, order=7)
    public String getOname() {
        return this.objName;
    }

    @Property(viewable=true, order=10)
    public int getHold_sid() {
        return this.holdSid;
    }

    @Property(viewable=true, order=11)
    public int getHold_pid() {
        return this.holdPid;
    }

    @Property(viewable=true, order=12)
    public int getHold_txid() {
        return this.holdTxid;
    }

    @Property(viewable=true, order=13)
    public String getHold_user() {
        return this.holdUser;
    }

    @Property(viewable=true, order=14)
    public String getHold_query() {
        return this.holdQuery;
    }

    public AltibaseDataSource getDataSource() {
        return this.dataSource;
    }
}

