/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;
import proguard.util.MultiValueMap;

public class ExtraDataEntryWriter
implements DataEntryWriter {
    private final MultiValueMap<String, String> extraEntryNameMap;
    private final Set<String> extraEntryNamesWritten = new HashSet<String>();
    private final DataEntryWriter dataEntryWriter;
    private final DataEntryWriter extraDataEntryWriter;
    private final String entrySuffix;

    public ExtraDataEntryWriter(String extraEntryName, DataEntryWriter dataEntryWriter) {
        this(extraEntryName, dataEntryWriter, dataEntryWriter);
    }

    public ExtraDataEntryWriter(String extraEntryName, DataEntryWriter dataEntryWriter, DataEntryWriter extraDataEntryWriter) {
        this(new MultiValueMap<String, String>(), dataEntryWriter, extraDataEntryWriter, null);
        this.extraEntryNameMap.put(null, extraEntryName);
    }

    public ExtraDataEntryWriter(MultiValueMap<String, String> extraEntryNameMap, DataEntryWriter dataEntryWriter, DataEntryWriter extraDataEntryWriter, String entrySuffix) {
        this.extraEntryNameMap = extraEntryNameMap;
        this.dataEntryWriter = dataEntryWriter;
        this.extraDataEntryWriter = extraDataEntryWriter;
        this.entrySuffix = entrySuffix;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        this.writeExtraEntries(dataEntry, null);
        this.writeExtraEntries(dataEntry);
        return this.dataEntryWriter.createOutputStream(dataEntry);
    }

    private void writeExtraEntries(DataEntry dataEntry) throws IOException {
        String mapKey = dataEntry.getName();
        if (this.entrySuffix != null && mapKey.endsWith(this.entrySuffix)) {
            mapKey = mapKey.substring(0, mapKey.length() - this.entrySuffix.length());
        }
        this.writeExtraEntries(dataEntry, mapKey);
    }

    private void writeExtraEntries(DataEntry dataEntry, String key) throws IOException {
        Set<String> extraEntryNames = this.extraEntryNameMap.get(key);
        if (extraEntryNames != null) {
            for (String extraEntryName : extraEntryNames) {
                if (this.extraEntryNamesWritten.contains(extraEntryName)) continue;
                String fullEntryName = this.entrySuffix != null ? extraEntryName + this.entrySuffix : extraEntryName;
                RenamedDataEntry extraEntry = new RenamedDataEntry(dataEntry, fullEntryName);
                this.extraDataEntryWriter.createOutputStream(extraEntry);
                this.extraEntryNamesWritten.add(extraEntryName);
                this.writeExtraEntries(extraEntry);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "ExtraDataEntryWriter");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }
}

