from datetime import date, datetime
from typing import Any, Dict, Optional, Union

from github.GithubObject import CompletableGithubObject, _NotSetType
from github.Label import Label
from github.NamedUser import NamedUser
from github.PaginatedList import PaginatedList

class Milestone(CompletableGithubObject):
    def __repr__(self) -> str: ...
    @property
    def _identity(self) -> int: ...
    def _initAttributes(self) -> None: ...
    def _useAttributes(self, attributes: Dict[str, Any]) -> None: ...
    @property
    def closed_issues(self) -> int: ...
    @property
    def created_at(self) -> datetime: ...
    @property
    def creator(self) -> NamedUser: ...
    def delete(self) -> None: ...
    @property
    def description(self) -> str: ...
    @property
    def due_on(self) -> Optional[datetime]: ...
    def edit(
        self,
        title: str,
        state: Union[_NotSetType, str] = ...,
        description: Union[_NotSetType, str] = ...,
        due_on: Union[date, _NotSetType] = ...,
    ) -> None: ...
    def get_labels(self) -> PaginatedList[Label]: ...
    @property
    def id(self) -> int: ...
    @property
    def labels_url(self) -> str: ...
    @property
    def number(self) -> int: ...
    @property
    def open_issues(self) -> int: ...
    @property
    def state(self) -> str: ...
    @property
    def title(self) -> str: ...
    @property
    def updated_at(self) -> datetime: ...
    @property
    def url(self) -> str: ...
